/*
 * a.lp_mp3 - Open Source Atmel AVR based MP3 Player
 * Copyright (c) 2003-2004 K. John '2B|!2B' Crispin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA02111-1307USA
 *
 * Feedback, Bugs.... mail john{AT}phrozen.org
 *
 */
 
#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>

#define MMC_CS_DDR	DDRB
#define MMC_CS_PIN	PINB
#define MMC_CS_PORT	PORTB

#define PIN_MMC_CS PB2
//#define PIN_MMC_ALLOW_SCI PB0
//#define ALLOW_SCI 		sbi(MMC_CS_PORT, PIN_MMC_ALLOW_SCI)
//#define NO_ALLOW_SCI 	cbi(MMC_CS_PORT, PIN_MMC_ALLOW_SCI)
// look in datasheet for complete list of commands
#define MMC_CMD_0_GO_IDLE				0
#define MMC_CMD_1_SEND_OP_COND			1
#define MMC_CMD_9_SEND_CSD				9
#define MMC_CMD_10_SEND_CID				10
#define MMC_CMD_12_STOP					12
#define MMC_CMD_13_SEND_STATUS			13
#define MMC_CMD_16_BLOCKLEN				16
#define MMC_CMD_17_READ_SINGLE			17
#define MMC_CMD_18_READ_MULTIPLE		18
#define MMC_CMD_24_WRITE_SINGLE			0x18

// bit definitions for R1
#define MMC_R1_IN_IDLE 	0x01
#define MMC_R1B_BUSY_BYTE 0x00

// different defines for tokens etc ...
#define MMC_START_TOKEN_SINGLE  0xfe
#define MMC_START_TOKEN_MULTI   0xfc

// errors for fat32
#define FAT_INVALID_ID			0x00
#define FAT_OK					0x01


// this structure holds info on the MMC card currently inserted 
typedef struct _VOLUME_INFO{
  u08   size_MB;
  u08   sector_multiply;
  u16   sector_count;
  u08	name[6];
} VOLUME_INFO;

// starts the hardware
void MMC_hw_init(void);
// starts up the MMC card
void MMC_init(void);
// starts the read process of a sector
void MMC_get_sec_start(u16 sectorh, u16 sectorl);
// starts the read process of a part of a sector 
void MMC_get_part_sec_start(u16 sectorh, u16 sectorl, u16 offset, u16 length);
// gets the next byte from the MMC card
u08 MMC_get_sec_next(void);
// stop read process of a sector
void MMC_get_sec_stop(void);

// deselcets the MMC
void MMC_CS_deselect(void);
//selects the MMC for transmission
void MMC_CS_select(void);

// sends receives a byte on the spi bus
u08 MMC_io(u08 data);

void MMC_cleanup(void);


//---------------------------------------

void mmc_load_buf(u32 s);

u08 mmc_fetch_buf(void);

