/******************************************************************************\
* Projekt:                                                                     *
* Ziel-System:                                                                 *
* Autor: Marco Kaminski                                                        *
* Version: v0.a.001                                                            *
* Datum: 01.12.2012                                                            *
*                                                                              *
* Beschreibung:                                                                *
* structs der USB-Descriptoren                                                 *
*                                                                              *
* Changelog:                                                                   *
* v0.a.001 - Erste Version                                                     *
*                                                                              *
* Lizenz:                                                                      *
* Dieses Programm ist freie Software. Sie können es unter den Bedingungen      *
* der GNU General Public License, wie von der Free Software Foundation         *
* veröffentlicht, weitergeben und/oder modifizieren, entweder gemäß Version    *
* 2 der Lizenz oder (nach Ihrer Option) jeder späteren Version.                *
*                                                                              *
* Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es        *
* Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die    *
* implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN          *
* BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.      *
*                                                                              *
* Sie sollten eine Kopie der GNU General Public License zusammen mit diesem    *
* Programm erhalten haben.                                                     *
* Falls nicht, schreiben Sie an die Free Software Foundation,                  *
* Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                *
\******************************************************************************/
#ifndef USB_H_
#define USB_H_

struct DeviceDescr {
	uint8_t		bLength;				//< Size of the Descriptor in Bytes (18 bytes)
	uint8_t		bDescriptorType;		//< Device Descriptor (0x01)
	uint16_t	bcdUSB;					//< USB Specification Number which device complies too.
	uint8_t		bDeviceClass;			//< Class Code (Assigned by USB Org)
										//  If equal to Zero, each interface specifies it’s own class code
										//  If equal to 0xFF, the class code is vendor specified.
										//  Otherwise field is valid Class Code.
	uint8_t		bDevciceSubClass;		//< Subclass Code (Assigned by USB Org)
	uint8_t		bDeviceProtocol;		//< Protocol Code (Assigned by USB Org)
	uint8_t		bMaxPacketSize;			//< Maximum Packet Size for Zero Endpoint. Valid Sizes are 8, 16, 32, 64
	uint16_t	idVendor;				//< Vendor ID (Assigned by USB Org)
	uint16_t	idProduct;				//< Product ID (Assigned by Manufacturer)
	uint16_t	bcdDevice;				//< Device Release Number
	uint8_t		iManufacturer;			//< Index of Manufacturer String Descriptor
	uint8_t		iProduct;				//< Index of Product String Descriptor
	uint8_t		iSerialNumber;			//< Index of Serial Number String Descriptor
	uint8_t		bNumConfigurations;		//< Number of Possible Configurations
};

struct ConfigDescr {
	uint8_t		bLength;				//< Size of the Descriptor in Bytes (9 bytes)
	uint8_t		bDescriptorType;		//< Configuration Descriptor (0x02)
	uint16_t	wTotalLength;			//< Total length in bytes of data returned
	uint8_t		bNumInterfaces;			//< Number of Interfaces
	uint8_t		bConfigurationValue;	//< Value to use as an argument to select this configuration
	uint8_t		iConfiguration;			//< Index of String Descriptor describing this configuration
	uint8_t		bmAttributes;			//< D7 Reserved, set to 1. (USB 1.0 Bus Powered)
										//  D6 Self Powered
										//  D5 Remote Wakeup
										//  D4..0 Reserved, set to 0.
	uint8_t		bMaxPower;				//< Maximum Power Consumption in 2mA units
};

struct InterfaceDescr {
	uint8_t		bLength;				//< Size of the Descriptor in Bytes (9 bytes)
	uint8_t		bDescriptorType;		//< Interface Descriptor (0x04)
	uint8_t		bInterfaceNumber;		//< Number of Interface
	uint8_t		bAlternateSetting;		//< Value used to select alternative setting
	uint8_t		bNumEndpoints;			//< Number of Endpoints used for this interface
	uint8_t		bInterfaceClass;		//< Class Code (Assigned by USB Org)
	uint8_t		bInterfaceSubClass;		//< Subclass Code (Assigned by USB Org)
	uint8_t		bInterfaceProtocol;		//< Protocol Code (Assigned by USB Org)
	uint8_t		iInterface;				//< Index of String Descriptor Describing this interface
};

struct EndpointDescr {
	uint8_t		bLength;				//< Size of the Descriptor in Bytes (7 bytes)
	uint8_t		bDescriptorType;		//< Endpoint Descriptor (0x05)
	uint8_t		bEndpointAddress;		//< Endpoint Address
										//  Bits 0..3b Endpoint Number.
										//  Bits 4..6b Reserved. Set to Zero
										//  Bits 7 Direction 0 = Out, 1 = In (Ignored for Control Endpoints)
	uint8_t		bmAttributes;			//< Bits 0..1 Transfer Type
										//    00 = Control
										//    01 = Isochronous
										//    10 = Bulk
										//    11 = Interrupt
										//  Bits 2..7 are reserved. If Isochronous endpoint,
										//  Bits 3..2 = Synchronisation Type (Iso Mode)
										//    00 = No Synchonisation
										//    01 = Asynchronous
										//    10 = Adaptive
										//    11 = Synchronous
										//  Bits 5..4 = Usage Type (Iso Mode)
										//    00 = Data Endpoint
										//    01 = Feedback Endpoint
										//    10 = Explicit Feedback Data Endpoint
										//    11 = Reserved
	uint16_t	wMaxPacketSize;			//< Maximum Packet Size this endpoint is capable of sending or receiving
	uint8_t		bInterval;				//< Interval for polling endpoint data transfers. Value in frame counts.
										//  Ignored for Bulk & Control Endpoints. Isochronous must equal 1 and
										//  field may range from 1 to 255 for interrupt endpoints.
};

struct StringDescr {
	uint8_t		bLength;				//< Size of the Descriptor in Bytes (7 bytes)
	uint8_t		bDescriptorType;		//< String Descriptor (0x03)
	uint8_t*	data;					//< String-Data
										//  String Index 0 should return a list of supported languages.
};

typedef struct USBString {
	struct	StringDescr			Descriptor;
	struct StringDescr**		StringList;
} USBString_t;

typedef struct USBInterface {
	struct	InterfaceDescr		Descriptor;
	struct EndpointDescr*		EndpointList;
			USBString_t*		Description;
} USBInterface_t;

typedef struct USBConfig {
	struct	ConfigDescr			Descriptor;
			USBInterface_t*		InterfaceList;
			USBString_t*		Description;
} USBConfig_t;

typedef struct USBDevice {
			uint8_t				Address;
	struct DeviceDescr			Descriptor;
			USBConfig_t*		ConfigureList;
			USBString_t*		Manufacturer;
			USBString_t*		Product;
			USBString_t*		SerialNumber;
	struct	USBDevice*			next;
} USBDevice_t;

#endif
