/******************************************************************************\
* Projekt: USB-Host                                                            *
* Ziel-System: LPCxpresso1769 + LPCxpresso Baseboard                           *
* Autor: Marco Kaminski                                                        *
* Version: v0.a.001                                                            *
* Datum: 01.12.2012                                                            *
*                                                                              *
* Beschreibung:                                                                *
* USB-Stack des LPC1769 konfigurieren und die Descriptoren der angesteckten    *
* USB-Gerate ausgeben.                                                         *
*                                                                              *
* Changelog:                                                                   *
* v0.a.001 - Erste Version                                                     *
*                                                                              *
* Lizenz:                                                                      *
* Dieses Programm ist freie Software. Sie können es unter den Bedingungen      *
* der GNU General Public License, wie von der Free Software Foundation         *
* veröffentlicht, weitergeben und/oder modifizieren, entweder gemäß Version    *
* 2 der Lizenz oder (nach Ihrer Option) jeder späteren Version.                *
*                                                                              *
* Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es        *
* Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die    *
* implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN          *
* BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.      *
*                                                                              *
* Sie sollten eine Kopie der GNU General Public License zusammen mit diesem    *
* Programm erhalten haben.                                                     *
* Falls nicht, schreiben Sie an die Free Software Foundation,                  *
* Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                *
\******************************************************************************/
#include <stdio.h>

#ifdef __USE_CMSIS
#include "LPC17xx.h"
#endif

#ifdef __USE_DRIVER
#include "lpc_types.h"
#include "lpc17xx_iap.h"
#include "lpc17xx_gpio.h"
#endif

#include <cr_section_macros.h>
#include <NXP/crp.h>

#include "global_inc.h"
#include "usart.h"
#include "usb.h"
#include "ohci.h"

// Variable to store CRP value in. Will be placed automatically
// by the linker when "Enable Code Read Protect" selected.
// See crp.h header for more information
__CRP const unsigned int CRP_WORD = CRP_NO_CRP ;

extern USBDevice_t DeviceListHead;
extern volatile  uint32_t	RhScIntr;
extern uint8_t lastAddress;

int main() {
    int32_t  rc;
	uint8_t  i,c,e;
	uint32_t d, PartID, DevSerial[4];
    USBDevice_t *device;

    // Initialisierung der Taktgeber in der CMSIS
	SystemCoreClockUpdate();

	// Seriennummer und CPU-Variante auslesen
	ReadDeviceSerialNum(DevSerial);
	ReadPartID(&PartID);

    // USART für Debug-Ausgaben initialisieren
    init_USART();

    // Ein paar Informationen zur CPU ausgeben.
    printf("USB-Test\r\nVersion: %s\r\n", _VERSION_);
	printf("SystemCoreClock: %lu\r\n", SystemCoreClock);
	printf("CPUID:\r\n");
	printf(" Implementer %lu\r\n", (SCB->CPUID & SCB_CPUID_IMPLEMENTER_Msk) >> SCB_CPUID_IMPLEMENTER_Pos);
	printf(" Variant     %lu\r\n", (SCB->CPUID & SCB_CPUID_VARIANT_Msk) >> SCB_CPUID_VARIANT_Pos);
	printf(" Partnumber  %lu\r\n", (SCB->CPUID & SCB_CPUID_PARTNO_Msk) >> SCB_CPUID_PARTNO_Pos);
	printf(" Revision    %lu\r\n", (SCB->CPUID & SCB_CPUID_REVISION_Msk) >> SCB_CPUID_REVISION_Pos);
	printf("PartID: %lx\r\n", PartID);
	printf("DeviceSerialnumber: %lx-%lx-%lx-%lx\r\n\r\n", DevSerial[3], DevSerial[2], DevSerial[1], DevSerial[0]);

    // USB_host Controller initialisieren
	init_USBHost();

	// LED an P0.22 für Debug-Zwecke initialisieren
	LPC_GPIO0->FIODIR = (1 << 22);
	LPC_GPIO0->FIOCLR = (1 << 22);

	// Hauptschleife
    while(1) {
    	printf("Ein USB-Geraet an den USB-Port stecken.\r\n");
		d = 1000000;

		// Warten bis ein Gerät angeschlossen wurde.
		while (!RhScIntr) {
			// LED an P0.22 blinken lassen
			if (d == 500000) {
				LPC_GPIO0->FIOCLR = (1 << 22);
			} else if (d == 0) {
				LPC_GPIO0->FIOSET = (1 << 22);
				d = 1000000;
			}
			d--;
		}

		// USB-Host nach geräten durchsuchen
		rc = enumerateDevice();;

		// Device entfernt
		if (lastAddress == 0)
			continue;

		// Wurde ein neues Geraet gefunden ?
		if (rc == OK) {
			// Das Geraet in der Liste suchen
			device = &DeviceListHead;
			do {
				if (device != NULL && device->Address != lastAddress)
					device = device->next;
				else
					break;
			} while (device != NULL);

			// Wurde das Geraet nicht gefunden ?
			if (device == NULL) {
				printf("No descriptor found!\r\n");
				continue;
			}

			// Ausgabe aller Deskriptoren
			printf("\r\nDevice Descriptor %i\r\n", lastAddress);
			printf("  bLength:              0x%02x\r\n",device->Descriptor.bLength);
			printf("  bDescriptorType:      0x%02x\r\n",device->Descriptor.bDescriptorType);
			printf("  bcdUSB:             0x%04x\r\n",device->Descriptor.bcdUSB);
			printf("  bDeviceClass:         0x%02x\r\n",device->Descriptor.bDeviceClass);
			printf("  bDevciceSubClass:     0x%02x\r\n",device->Descriptor.bDevciceSubClass);
			printf("  bDeviceProtocol:      0x%02x\r\n",device->Descriptor.bDeviceProtocol);
			printf("  bMaxPacketSize:       0x%02x\r\n",device->Descriptor.bMaxPacketSize);
			printf("  idVendor:           0x%04x\r\n",device->Descriptor.idVendor);
			printf("  idProduct:          0x%04x\r\n",device->Descriptor.idProduct);
			printf("  bcdDevice:          0x%04x\r\n",device->Descriptor.bcdDevice);
			printf("  iManufacturer:        0x%02x\r\n",device->Descriptor.iManufacturer);
			printf("  iProduct:             0x%02x\r\n",device->Descriptor.iProduct);
			printf("  iSerialNumber:        0x%02x\r\n",device->Descriptor.iSerialNumber);
			printf("  bNumConfigurations:   0x%02x\r\n",device->Descriptor.bNumConfigurations);
			for (c=0;c<device->Descriptor.bNumConfigurations;c++) {
				printf("\r\n  Configuartion Descriptor %i\r\n",c+1);
				printf("    bLength:             0x%02x\r\n",device->ConfigureList[c].Descriptor.bLength);
				printf("    bDescriptorType:     0x%02x\r\n",device->ConfigureList[c].Descriptor.bDescriptorType);
				printf("    wTotalLength:      0x%04x\r\n",device->ConfigureList[c].Descriptor.wTotalLength);
				printf("    bNumInterfaces:      0x%02x\r\n",device->ConfigureList[c].Descriptor.bNumInterfaces);
				printf("    bConfigurationValue: 0x%02x\r\n",device->ConfigureList[c].Descriptor.bConfigurationValue);
				printf("    iConfiguration:      0x%02x\r\n",device->ConfigureList[c].Descriptor.iConfiguration);
				printf("    bmAttributes:        0x%02x\r\n",device->ConfigureList[c].Descriptor.bmAttributes);
				printf("    bMaxPower:           0x%02x\r\n",device->ConfigureList[c].Descriptor.bMaxPower);
				for(i=0;i<device->ConfigureList[c].Descriptor.bNumInterfaces;i++) {
					printf("\r\n    Interface Descriptor %i\r\n",i+1);
					printf("      bLength:            0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bLength);
					printf("      bDescriptorType:    0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bDescriptorType);
					printf("      bInterfaceNumber:   0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bInterfaceNumber);
					printf("      bAlternateSetting:  0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bAlternateSetting);
					printf("      bNumEndpoints:      0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bNumEndpoints);
					printf("      bInterfaceClass:    0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bInterfaceClass);
					printf("      bInterfaceSubClass: 0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bInterfaceSubClass);
					printf("      bInterfaceProtocol: 0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.bInterfaceProtocol);
					printf("      iInterface:         0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].Descriptor.iInterface);
					for(e=0;e<device->ConfigureList[c].InterfaceList[i].Descriptor.bNumEndpoints;e++) {
						printf("\r\n      Endpoint Descriptor %i\r\n",e+1);
						printf("        bLength:            0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].bLength);
						printf("        bDescriptorType:    0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].bDescriptorType);
						printf("        bEndpointAddress:   0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].bEndpointAddress);
						printf("        bmAttributes:       0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].bmAttributes);
						printf("        wMaxPacketSize:   0x%04x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].wMaxPacketSize);
						printf("        bInterval:          0x%02x\r\n",device->ConfigureList[c].InterfaceList[i].EndpointList[e].bInterval);
					}
				}
			}
		} else {
			printf("Fehler beim lesen der Descriptoren.\r\n");
		}
    }
}
