/******************************************************************************\
* Projekt:                                                                     *
* Ziel-System: LPC17xx                                                         *
* Autor: Marco Kaminski                                                        *
* Version: v0.a.001                                                            *
* Datum: 10.09.2012                                                            *
*                                                                              *
* Beschreibung:                                                                *
* USART0 Initialisierung. Minmal-Konfiguration fuers debuggen per printf.      *
*                                                                              *
* Changelog:                                                                   *
* v0.a.001 - Erste Version                                                     *
*                                                                              *
* Lizenz:                                                                      *
* Dieses Programm ist freie Software. Sie können es unter den Bedingungen      *
* der GNU General Public License, wie von der Free Software Foundation         *
* veröffentlicht, weitergeben und/oder modifizieren, entweder gemäß Version    *
* 2 der Lizenz oder (nach Ihrer Option) jeder späteren Version.                *
*                                                                              *
* Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es        *
* Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die    *
* implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN          *
* BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.      *
*                                                                              *
* Sie sollten eine Kopie der GNU General Public License zusammen mit diesem    *
* Programm erhalten haben.                                                     *
* Falls nicht, schreiben Sie an die Free Software Foundation,                  *
* Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                *
\******************************************************************************/
#ifdef __USE_CMSIS
#include "LPC17xx.h"
#endif

#ifdef __USE_DRIVER
#include "lpc_types.h"
#include "lpc17xx_pinsel.h"
#include "lpc17xx_uart.h"
#endif

#include "global_inc.h"

#if (__REDLIB_INTERFACE_VERSION__ >= 20000)
	#ifdef __REDLIB__
		// We are using new Redlib_v2 semihosting interface
		#define WRITEFUNC __sys_write
		#define READFUNC __sys_readc
	#endif
	#ifdef __NEWLIB__
		// We are using new Redlib_v2 semihosting interface
		#define WRITEFUNC _write
		#define READFUNC _read
	#endif
#else
// We are using original Redlib semihosting interface
	#define WRITEFUNC __write
	#define READFUNC __readc
#endif

void init_USART() {
	PINSEL_CFG_Type PinConfig;

	// Config TX-Pin to USART0
	PinConfig.Portnum	= PINSEL_PORT_0;
	PinConfig.Pinnum	= PINSEL_PIN_2;
	PinConfig.Funcnum	= PINSEL_FUNC_1;
	PinConfig.Pinmode	= PINSEL_PINMODE_PULLUP;
	PinConfig.OpenDrain	= PINSEL_PINMODE_NORMAL;
	PINSEL_ConfigPin(&PinConfig);

	// Config RX-Pin to USART0
	PinConfig.Portnum	= PINSEL_PORT_0;
	PinConfig.Pinnum	= PINSEL_PIN_3;
	PinConfig.Funcnum	= PINSEL_FUNC_1;
	PinConfig.Pinmode	= PINSEL_PINMODE_PULLUP;
	PinConfig.OpenDrain	= PINSEL_PINMODE_NORMAL;
	PINSEL_ConfigPin(&PinConfig);

	UART_CFG_Type UARTConfig;
	UART_FIFO_CFG_Type FIFOConfig;

	UART_ConfigStructInit(&UARTConfig);
	UARTConfig.Baud_rate = 115200;
	UART_Init((LPC_UART_TypeDef*)LPC_UART0, &UARTConfig);

	UART_FIFOConfigStructInit(&FIFOConfig);
	UART_FIFOConfig((LPC_UART_TypeDef*)LPC_UART0, &FIFOConfig);
	UART_TxCmd((LPC_UART_TypeDef*)LPC_UART0, ENABLE);
}

int WRITEFUNC (int iFileHandle, char *pcBuffer, int iLength) {
	UART_Send((LPC_UART_TypeDef*)LPC_UART0,(uint8_t *)pcBuffer,iLength,BLOCKING);
	return iLength;
}
