/******************************************************************************\
* Projekt:                                                                     *
* Ziel-System: LPC17xx                                                         *
* Autor: Marco Kaminski                                                        *
* Version: v0.a.001                                                            *
* Datum: 08.12.2012                                                            *
*                                                                              *
* Beschreibung:                                                                *
* Kleine Hilfsfunktionen.                                                      *
*                                                                              *
* Changelog:                                                                   *
* v0.a.001 - Erste Version                                                     *
*                                                                              *
* Lizenz:                                                                      *
* Dieses Programm ist freie Software. Sie können es unter den Bedingungen      *
* der GNU General Public License, wie von der Free Software Foundation         *
* veröffentlicht, weitergeben und/oder modifizieren, entweder gemäß Version    *
* 2 der Lizenz oder (nach Ihrer Option) jeder späteren Version.                *
*                                                                              *
* Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es        *
* Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die    *
* implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN          *
* BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.      *
*                                                                              *
* Sie sollten eine Kopie der GNU General Public License zusammen mit diesem    *
* Programm erhalten haben.                                                     *
* Falls nicht, schreiben Sie an die Free Software Foundation,                  *
* Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.                *
\******************************************************************************/
#ifdef __USE_CMSIS
#include "LPC17xx.h"
#endif

#ifdef __USE_DRIVER
#include "lpc_types.h"
#include "lpc17xx_systick.h"
#endif

#include "utils/delay.h"

void _delay_ms(float time) {
	// calculate maxtime in ms
	float maxtime = (1<<24)/(SystemCoreClock / 1000);

	// disable System Tick counter, System Tick interrupt and clear countflag
	SysTick->CTRL &= ~(ST_CTRL_ENABLE | ST_CTRL_TICKINT | ST_CTRL_COUNTFLAG);
	// Select CPU clock is System Tick clock source
	SysTick->CTRL |= ST_CTRL_CLKSOURCE;

	// set realod value
	if (time < maxtime) {
		SysTick->LOAD = (uint32_t)((SystemCoreClock/1000)*time) - 1;
	} else {
		SysTick->LOAD = (1<<24) - 1;
	}

	// enable System Tick counter
	SysTick->CTRL |= ST_CTRL_ENABLE;

	// wait for System Tick countflag
	while (!(SysTick->CTRL & ST_CTRL_COUNTFLAG));

	// disable System Tick counter
	SysTick->CTRL &= ~ST_CTRL_ENABLE;
}
