
#define F_CPU 2000000

#include "avr/io.h"
#include "avr/interrupt.h"
#include "string.h"
#include "stddef.h"																							
#include "avr/pgmspace.h"																							
#include "stdlib.h"
#include "util/delay.h"
#include "usart.h"
#include "adc.h"
#include "motor.h"

int vorlauf;
int rucklauf;
int temp_differenz;
char ausgabe;

void init()
{
	PORTA_DIR = 0x00;
	PORTA_PIN7CTRL = 0x18;
	PORTH_DIR = 0xFF;
	PORTH_OUT = 0xff;
	ADCA_init();
	USART_init(&USARTF1, &PORTF, 0x80);
}
	
int main(void)
{
	init();
    while(1)
    {
		if (!(PORTA_IN & 0b10000000))
		{
		_delay_ms(25);
		PORTH_OUT = 0b10100000;
		vorlauf = ADCA_Conversion(&(ADCA.CH0),1);
		rucklauf = ADCA_Conversion(&(ADCA.CH0),2);
		
		temp_differenz =vorlauf-rucklauf;
				
		itoa(temp_differenz,ausgabe,10);
		send_USART(&USARTF1, ausgabe);
		}
    }
}