//////////////////////////////////////////////////////////////////////////////////
//ADC.c																			//
//fr ATXmega128a1																//
//																				//
//in void main gehrt die Initialisierung										//
//ADCA_init();																	//
//man darf den PortA dann nur noch als ADC_eingang benutzen						//
//Die Referenzspannung ist 1V													//
//																				//
//Beispiel fr eine Messung die dann in eine Variable mit int gespeichert wird	//
//ADC_Value ist die int variable												//
//ADC_Value = ADCA_Conversion(&(ADCA.CH0), 1);									//
//ADCA_CH0 bedeutet das der kanal 0 von 4 benutzt wird							//
//Die letzte Zahl, hier 1, bedeutet welcher Pin abgefragt wird					//
//////////////////////////////////////////////////////////////////////////////////




//ADC initialisieren
void ADCA_init()
{
	ADCA.CTRLB = ADC_RESOLUTION_12BIT_gc;		//Unsigned Mode / 8 Bit
	ADCA.REFCTRL = ADC_REFSEL_INT1V_gc | 0x02;	//Interne 1V Referenz	
	ADCA.PRESCALER = ADC_PRESCALER_DIV512_gc;	//Prescaler auf 512 stellen
	ADCA.CTRLA = ADC_ENABLE_bm;			//ADC Enable
	PORTA.DIR = 0x00;				//Port A als Eingang setzen
}


//Messung starten
unsigned int ADCA_Conversion(ADC_CH_t *Channel, char Pin)
{
	Channel->CTRL = ADC_CH_INPUTMODE_SINGLEENDED_gc;//Single Ended Mode einstellen
	Channel->MUXCTRL = (Pin << 3);			//Pin auswhlen
	
	Channel->CTRL |= ADC_CH_START_bm;		//Messung starten und Input-Mode auf Singleended stellen
	while(!Channel->INTFLAGS);
	return Channel->RES;				//Inhalt des Datenregisters auslesen
}