//////////////////////////////////////////////////////////////////////////////////
//USART.c																		//
//fr ATXmega128a1																//	
//nur fr 2MHz																	//
//ACHTUNG Baudrate gehrt noch berechnet, momentan ist fr 32MHz eingestellt	//
//																				//
//																				//
//In void main die initialisierung												//
//USART_init(&USARTF1, &PORTF, 0x80);											//
//send_USART(&USARTF1, "ADC Testprogramm");										//
//Beispiel ist fr USARTF1, ausgegeben wird ADC Testprogramm					//
//////////////////////////////////////////////////////////////////////////////////
#include "usart.h"

void USART_init(USART_t *USART, PORT_t *Port, char Value)
{
	USART->BAUDCTRLB = 0;	//Baudrate auf 19200@32MHz gendert								//Baudrateneinstellung
	USART->BAUDCTRLA = 0x68;																//Baudrateneinstellung fr groe Werte 2 register
	USART->CTRLA = USART_RXCINTLVL_HI_gc;													//Interruptprioritt (RX Interrupt Hchste)
	USART->CTRLB = USART_TXEN_bm | USART_RXEN_bm;											//USART aktivieren RX und TX
	USART->CTRLC = USART_CHSIZE_8BIT_gc;													//8bit bertragung
	Port->DIR = Value;				//USARTF1 = 0x80										//PF7 als Ausgang, UART TX
}


//send_USART(&USARTF1, "ADC Testprogramm");
//Beispiel ist fr USARTF1, ausgegeben wird ADC Testprogramm
void send_USART(USART_t *USART, char data[])
{
	char Counter;
	char lenght = 0;
	
	lenght =strlen(data);
	
	while(Counter < lenght)
	{
		while (!(USART->STATUS & USART_DREIF_bm));
		USART->DATA = data[Counter];
		Counter++;
	}
	Counter =0;
	while(!(USART->STATUS & USART_DREIF_bm));
	USART -> DATA = 0x0A;
	while(!(USART->STATUS & USART_DREIF_bm));
	USART -> DATA = 0x0D;
}




