/*************************************************************************

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

*************************************************************************/

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include "uart.h"
#include "ns741.h"


#define BAUD 115200UL      // Baudrate


int main(void)
{
	/* init UART und printf */
	uart_init( UART_BAUD_SELECT(BAUD, F_CPU) );

	/* enable Interrupts*/
	sei();

	/* Init FM-Transmitter */
	ns741_init();

	/* Set frequency to 88.6MHz(default value) */
	ns741_set_frequency(99300);

	/* Enable Transmission */
	ns741_power(1);
	
	/* Start RDS Transmission */
	ns741_rds_start();  // power must be on
						// else no RDINTs are generated

	/*
	 * Endless loop which changes the RDS program service name
	 * ca. each 2 seconds
	 */
	while(1)
	{
		ns741_rds_set_progname("Rolle FM");
		_delay_ms(5000);

		ns741_rds_set_progname("auf UKW!");
		_delay_ms(2000);

		_delay_ms(10000);
		ns741_rds_set_radiotext("nun aber mal was anderes ...");
	}
}
