library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.std_logic_unsigned.all;

entity InterfaceKarte is 
		PORT(
			-- Eingnge
			reset		:in std_logic;
			clk 		:in std_logic; 	-- Eingangstakt
			RAM_data_in_a	:in std_logic_vector(31 downto 0);
			RAM_data_out_a	:out std_logic_vector(31 downto 0);
			wren		:in std_logic;
			address2		:in std_logic_vector(7 downto 0);	
			-- Ausgnge
			);
end InterfaceKarte;


architecture Hauptprogramm of InterfaceKarte is


shared variable address_intern	: integer range 0 to 32;
shared variable RAM_data_in_b	: std_logic_vector(31 downto 0);
shared variable RAM_data_out_b	: std_logic_vector(31 downto 0);
shared variable RW_intern_b		: std_logic := '0';
signal clk_a					: std_logic := '0';
shared variable clk_b			: std_logic := '0';


component RAM
	PORT
	(
		address_a		: IN STD_LOGIC_VECTOR (7 DOWNTO 0);
		address_b		: IN STD_LOGIC_VECTOR (7 DOWNTO 0);
		clock_a		: IN STD_LOGIC ;
		clock_b		: IN STD_LOGIC ;
		data_a		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
		data_b		: IN STD_LOGIC_VECTOR (31 DOWNTO 0);
		wren_a		: IN STD_LOGIC  := '0';
		wren_b		: IN STD_LOGIC  := '0';
		q_a		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0);
		q_b		: OUT STD_LOGIC_VECTOR (31 DOWNTO 0)
	);
end component;

for RAM_inst: ram use entity work.ram(SYN);

begin

RAM_inst : RAM PORT MAP (
		address_a	 => address2,	-- externer Zugriff
		address_b	 => conv_std_logic_vector(address_intern, 8), -- interner Zugriff
		clock_a	 => clk_a,
		clock_b	 => clk_b,
		data_a	 => RAM_data_in_a,
		data_b	 => RAM_data_in_b,
		wren_a	 => wren,
		wren_b	 => RW_intern_b,
		q_a	 => RAM_data_out_a,
		q_b	 => RAM_data_out_b
	);
			

process
	begin
		clk_b := '0';
		address_intern := 7;
		RAM_data_in_b := "10001000100010001000100010001000";
		RW_intern_b := '1';
		wait until clk_b = '1';
		RW_intern_b := '0';	

end process;		
	

end Hauptprogramm;