###################################################################
# LCD2_4BP.MAK
#
# (C) 2003 www.Wickenhaeuser.com
#
# Using an LCD-Display for printf() in various modes
#
# Here: Direct connection to 4 bit PORT P1 is used for I/O. 
#
# The Display is connected as follows:
#
#    Display PINS
#
#     1  GND                                     
#     2  Vcc (optionally controlled by P1_B3, see below)
#     3  V_Cont  (contrast, usually somewhere 0..5 V, connect to a POTI)
#     4  RS  (register selection)     P1_B0
#     5  RW  (read/write)             P1_B1
#     6  EN  (chip clock)             P1_B2
#     7  DB0 -
#     8  DB1 - 
#     9  DB2 -
#     10 DB3 -
#     11 DB4 (data bit 4)                         P1_B4
#     12 DB5 (data bit 5)                         P1_B5
#     13 DB6 (data bit 6)                         P1_B6
#     14 DB7 (data bit 7)                         P1_B7
#
#     ? Vcc (backlight +)  optionally connected, model specific
#     ? GND (backlight -)
#
#     P1_B3 is used to (optionally) reset the display (if 1: Display power is switched of)
#
#############################################################

L51FLAGS = -r0,0
A51FLAGS = -g	# Listing ONLY
MODEL=small # small (default) or large

# C51FLAGS =  -dCPU_NSEC=650 # enable this definition, is the CPU is faster than a standard 8051/12MHz (see sourcecode and manual)

# This is the "user's" application, accessing an LCD-Display

lcd_4BP.obj: lcd_4BP.c
lcd_drv.obj: lcd_drv.c
lcd_dmo.obj: lcd_dmo.c

lcd_dmo.bin: lcd_4BP.obj lcd_drv.obj lcd_dmo.obj
lcd_dmo.hex: lcd_dmo.bin





# END

