/*******************************************************************
* LCD_DMO.C - Demo for LC-Display 
* This demos uses the LCD_DRV.C to access a LCD, no matter
* how it is connected. The LCD_DRV.C is using a specific module 
* LCD_IO.C, which is supplied for 3 different modes in uC/51:
* 
* - via I2C (see 'MSC1210/ELMET/..' too), using a standard 8 bit I2C I/O
* - direct connection to 8-bit controller Port (using 4-bit mode)
* - direct connection in 8-bit mode by memory mapping (see 'UPSD\')
*
* The LCD_DRV supports all standard 1x8 to 4x20 LCDs. Automatic
* Line-Feed is calculated for 4x20 LCDs.
*
* (C) 2003 Wickenhaeuser
*
*******************************************************************/

#include <stdio.h>
#include <reg51.h>

#include "lcd_drv.h"

#define LED P3_B5

/*********************** DEMO-TEXT ******************/
void main(void){
	uint cnt=19;

	if(lcd_init()) puts("NO DISPLAY FOUND!"); // Needs UART set up for ERROR text...

	lcd_cursor(LCD_CURSOR_OFF);	// Cursor OFF

	lcd_printf("<LCD2 DEMO V1.0>\n");
	lcd_printf("uC/51 C Compiler");

	_wait_ms(1000);
	lcd_clear();

	for(;;){
		LED^=1;
		lcd_gotoxy(0,1);
		lcd_printf("Test: ");
	

		// Display Number in LARGE digits
		lcd_d2_printf("%3d",cnt--); // Format to 3 digits
			
		// Display 4 Hartbeat......
		lcd_gotoxy(0,0); lcd_printf("*---");
		_wait_ms(200);
		lcd_gotoxy(0,0); lcd_printf("-*--");
		_wait_ms(200);
		lcd_gotoxy(0,0); lcd_printf("--*-");
		_wait_ms(200);
		lcd_gotoxy(0,0); lcd_printf("---*");
		_wait_ms(200);
	}
	
}

// EOF