// Routinen zum Setzen der Taktfrequenz
#include <71x_lib.h>
#include <71x_map.h> // Damit Registerdefinitionen bekannt sind
#include "clock.h"


void setclocks(void) // setzt Taktfrequenzen fr CPU und Peripherie
{
	RCCU_Div2Config( ENABLE );		// Input Clock Divider aktivieren:
	// CLK wird durch 2 dividiert in CLK2 eingespeist => 8 MHz Quarz mglich
	
	RCCU_MCLKConfig( RCCU_DEFAULT);	// MCLK fr CPU wird ohne weiteres Runterteilen aus RCLK gewonnen
	RCCU_FCLKConfig( RCCU_RCLK_2);	// FCLK fr Peripherie auf RCLK / 2 setzen				
	RCCU_PCLKConfig( RCCU_RCLK_2);	// FCLK fr Peripherie auf RCLK / 2 setzen
	RCCU_PLL1Config( RCCU_PLL1_Mul_16, RCCU_Div_1); // PLL auf Multiplikator von 16 und Teiler von 1 konfigurieren
	RCCU_RCLKSourceConfig( RCCU_PLL1_Output ); // PLL als Quelle fr Taktfrequenz auswhlen
}
