/**************************************************************************************
*	Demoprojekt fr die USARTs im IRQ-Betrieb
*
*	Empfangene Zeichen werden vom UART3_IRQHandler() in rxdaten[] zwischengespeichert
*	und bei \n der Empfang einer kompletten Befehlszeile mit command_complete gemeldet.
*	Der Befehlsstring wird dann in rs232job abgearbeitet.
*
*	Erstellt fr den STR711 unter Verwendung von Beispielcode der Anglia IDEaliST, 
*	siehe www.anglia-designs.com	
*
*	Copyright 2006 Michael Multerer, Franz Wudy
*	
*	
**************************************************************************************/

#define UART3_Rx_Pin (0x0001<<1)   /*  TQFP 64: pin N 52 , TQFP 144 pin N 123 */
#define UART3_Tx_Pin (0x0001<<0)   /*  TQFP 64: pin N 53 , TQFP 144 pin N 124 */

#define _EIC // 71x_lib.h sagen, da IRQs hergenommen werden
#include <71x_lib.h>
#include <71x_map.h> // Damit Registerdefinitionen bekannt sind
#include <71x_it.h> // fr Definitionen der IRQ-Handler
#include <stdio.h>
#include <string.h> // fr strstr
#include "clock.h"
#include <uart.h>

#define MAXINTEXT 51
volatile unsigned char rxdaten[MAXINTEXT];
volatile unsigned char irx = 0;
volatile unsigned char command_complete = 0;

void rs232job(void);

void USART_init(void)
{
	/*  Configure the GPIO pins as alternate function push pull */
	GPIO_Config(GPIO0,UART3_Tx_Pin, GPIO_AF_PP);
	/*  Configure the GPIO pins as Input Tristate CMOS */
	GPIO_Config(GPIO0,UART3_Rx_Pin, GPIO_IN_TRI_CMOS);

	UART3->BR = 1; // Baudrate einstellen: 1 = 2 MBit/s,  2 = 1 MBit/s, 4 = 500 kBit/s
	UART3->CR = (1 << 10) | (1 << 8) | (1 << 7) | (1 << 3) | ( 1 << 0);
	//			FIFOEnable	RX ENAB		BRGEN	   1STOP	8 databits
	UART3->IER |= (1 << 0);	
	// IRQ bei 	RXBuf nicht leer
	EIC->SIR[12] |= 0x00000005; // Fr IRQ12 = UART3 eine Prioritt von 5 einstellen
	// Wenn die Prioritt <= Sollwert (Standard 0) ist, wird der IRQ nicht aufgerufen
	EIC->IER |= 1<<12; // IRQ12 = UART3 einschalten

}

int main(void)
{	
	setclocks(); // Taktfrequenzen fr Core und Peripherie einstellen

	EIC->ICR |= 0x00000001; // Interrupts global aktivieren
	USART_init();
	GPIO_Config(GPIO1, 0xFFFF, GPIO_OUT_PP);
	
	while(1)
	{
		if(command_complete != 0) // falls ntig, RS232-Kommunikation machen
		{
			rs232job();
		}
	}
}

void rs232job(void)
{
	char *befehl;
	
	command_complete = 0;
	
	befehl = strstr(rxdaten, "ati"); // prfen, ob Befehl ati in rxdaten vorhanden ist
	if(befehl != NULL) 
	{
		UART_StringSend(UART3,(u8*) &"Hello World!\n"); // Antwort ausgeben
	}
	
	befehl = strstr(rxdaten, "atp"); // prfen, ob Befehl atp in rxdaten vorhanden ist
	if(befehl != NULL) 
	{
		GPIO1->PD = ~(GPIO1->PD); // schaltet GPIO komplett um
	}
}

