/*	Sample program for Olimex AVR-P28 with ATMega8 processor
 *	Blinks the led with a speed ~2Hz using a simple delay loop.
 *	Compile with AVRStudio+WinAVR (gcc version 3.4.6)
 */

#define	__AVR_ATmega8__	1

#include "avr/io.h"

void Initialize(void)
{
	PORTB = 0x0;
	PORTC = 1<<5;	/* turn the LED off */
	PORTD = 0x0;

	DDRB = 0x0;
	DDRC = 1<<5;	/* PC5 as output - the LED is there */
	DDRD = 0x0;

}

/*	state = 0 -> Led Off
 *	state = 1 -> Led On
 *	state !=[0,1] -> Led Toggle 
 */
void LedSet(unsigned char state)
{
	switch (state)
	{
		case 0:
			PORTC &= ~(1<<5);
			break;
		case 1:
			PORTC |= 1<<5;
			break;
		default:
			if (PORTC & 1<<5) 
				PORTC &= ~(1<<5);
			else
				PORTC |= 1<<5;
	}
	
}


int main(void)
{
	int i;

	Initialize();

	while (1)
	{
		LedSet(0);
		for (i=60000;i;i--);
		LedSet(1);
		for (i=60000;i;i--);
	}
	return 0;
}
