;############## M A I N ###########################
 

.CSEG
.org 0x000
       rjmp init
.org INT0addr                 ; External Interrupt0 Vector Address
       reti                   
.org INT1addr                 ; External Interrupt1 Vector Address
       reti;rjmp INT1_ISR                  
.org OC2addr                  ; Output Compare2 Interrupt Vector Address
       reti                   
.org OVF2addr                 ; Overflow2 Interrupt Vector Address
       reti                   
.org ICP1addr                 ; Input Capture1 Interrupt Vector Address
       reti                   
.org OC1Aaddr                 ; Output Compare1A Interrupt Vector Address
       reti                   
.org OC1Baddr                 ; Output Compare1B Interrupt Vector Address
       reti                   
.org OVF1addr                 ; Overflow1 Interrupt Vector Address
       reti                   
.org OVF0addr                 ; Overflow0 Interrupt Vector Address
       reti                   
.org SPIaddr                  ; SPI Interrupt Vector Address
       reti                   
.org URXCaddr                 ; USART Receive Complete Interrupt Vector Address
       reti                   
.org UDREaddr                 ; USART Data Register Empty Interrupt Vector Address
       reti                   
.org UTXCaddr                 ; USART Transmit Complete Interrupt Vector Address
       reti                   
.org ADCCaddr                 ; ADC Interrupt Vector Address
       reti                   
.org ERDYaddr                 ; EEPROM Interrupt Vector Address
       reti                   
.org ACIaddr                  ; Analog Comparator Interrupt Vector Address
       reti                   
.org TWIaddr                  ; Irq. vector address for Two-Wire Interface
       reti                   
.org SPMRaddr                  ; SPM complete Interrupt Vector Address
       reti

.include "m8def.inc"
.include "definitions.inc"
.include "delays.inc"
.include "macros.inc"
.include "functions.inc"
.include "interrupts.inc"

	 

init:
  init_stack:
    ldi R16, high(RAMEND) 
    out SPH, R16
    ldi R16, low(RAMEND)
    out SPL, R16
  init_led:
    SBI DDRD, PD7
    SBI DDRD, PD6
    CBI PORTD, PD7
    SBI DDRC, PC0
    SBI DDRC, PC1
  init_uart:
    ;SBI UCSRB, TXEN ;enable transmiting
    ;SBI UCSRB, RXEN ;enable recieving
  init_adc:
    ldi R16, (1 << ADEN) | (1 << ADPS2) | (1 << ADPS1)
    out ADCSRA, R16
  init_pwm:
    ldi R16, (1 << WGM10) | (1 << COM1A1) | (1 << COM1B1)
    out TCCR1A, R16
    ldi R16, (1 << CS11)
    out TCCR1B, R16
  init_motor:
    SBI DDRB, PB1
    SBI DDRB, PB2
    SBI DDRB, PB4
    SBI DDRB, PB5
    SBI DDRD, PD4
    SBI DDRD, PD5
    SBI PORTB, PB1 
    SBI PORTB, PB2
  init_interupt:
    in R16 , MCUCR
    SBR R16, (1 << ISC11)
    CBR R16, (1 << ISC10) ;faling will trigger an interrupt
    out MCUCR, R16
    in R16, GICR
    sbr R16, (1 << INT1);activate interupt1
    out GICR, R16
  init_PID_controller:
    ldi YL, low(Yk_add) ;store first multiplikator=kp+kd
	ldi Yh, high(Yk_add)
	ldi R16, 0
	st Y+, R16
	st Y+, R16
	st Y+, R16
	ldi YL, low(ek_add) ;store first multiplikator=kp+kd
	ldi Yh, high(ek_add)
	ldi R16, 0
	st Y+, R16
	ldi YL, low(ek_1_add) ;store first multiplikator=kp+kd
	ldi Yh, high(ek_1_add)
	ldi R16, 0
	st Y+, R16
    ldi YL, low(Y_Mult1_add) ;store first multiplikator=kp+kd
	ldi Yh, high(y_Mult1_add)
	ldi R16, low(Y_Mult1)
	st Y+, R16
	ldi R16, high(Y_Mult1)
	st Y, R16
	ldi YL, low(Y_Mult2_add) ;store second multiplikator = ki-kp-2kd
	ldi Yh, high(y_Mult2_add)
	ldi R16, low(Y_Mult2)
	st Y+, R16
	ldi R16, high(Y_Mult2)
	st Y, R16
	ldi YL, low(Kd_add) ;store kd
	ldi Yh, high(Kd_add)
	ldi R16, low(Kd)
	st Y+, R16
	ldi R16, high(Kd)
	st Y, R16
  init_interrupt:
    ;sei ;set global interrupt enable
	

main:
	;SWITCH_LEFT_BACKLED_OFF
	;SWITCH_RIGHT_BACKLED_OFF
	MotorDir_FWD_FWD
    ldi R16, motorspeed
    mov r_motorspeed_left, R16
    mov r_motorspeed_right, R16
    rcall change_motorspeed
  follow:
    SWITCH_TOPLED_ON
	rcall delay_10ms
	rcall get_left_onvalue
	rcall get_right_onvalue
	SWITCH_TOPLED_OFF
	rcall delay_10ms
	rcall get_left_offvalue
	rcall get_right_offvalue
	rcall compare_left
	rcall compare_right
	rcall compare_left_right
	rcall calculate_PID_controller
	SWITCH_LEFT_BACKLED_ON
    SWITCH_RIGHT_BACKLED_ON
	ldi YH, high(Yk_add)
	ldi YL, low(Yk_add)
	ld R16, Y+
	ld R17, Y+
	ld R18, Y
	TST R16
	BREQ main
	TST R18
	BRNE left_faster
	BRPL right_faster
  left_faster:
    ;SWITCH_LEFT_BACKLED_ON
	;SWITCH_RIGHT_BACKLED_OFF
    ;NEG_24bit R18,R17,R16
	;LSR R16
	;add r_motorspeed_left, R16
	;sub r_motorspeed_right, R16
	;rcall change_motorspeed
	;TRANSMIT R16
	;rcall delay_1s
    rjmp follow
  right_faster:
    ;SWITCH_LEFT_BACKLED_OFF
	;SWITCH_RIGHT_BACKLED_ON
    ;LSR R16
	;sub r_motorspeed_left, R16
	;add r_motorspeed_right, R16
	;rcall change_motorspeed
	;TRANSMIT R16
	;rcall delay_1s
    rjmp follow


    