.include "m8def.inc"


;########################### F U N C T I O N S #################################

change_motorspeed:
  push R16
  clr R16
  out OCR1AH, R16
  out OCR1AL, r_motorspeed_left
  out OCR1BL, r_motorspeed_right
  pop R16
RET


get_left_onvalue:
   push R16
   push YH
   push YL
   ldi YH, high(LEFT_ON) 
   ldi YL, low(LEFT_ON)
   SET_LEFT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   ;rcall delay_10ms
   GET_ADC_VALUE R16
   ;addi R16,2 ;error correction
   st Y,R16
   pop YL
   pop YH
   pop R16
RET


get_right_onvalue:
   push R16
   push YH
   push YL
   ldi YH, high(RIGHT_ON)
   ldi YL, low(RIGHT_ON)
   SET_RIGHT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   ;rcall delay_10ms
   GET_ADC_VALUE R16
   st Y,R16
   pop YL
   pop YH
   pop R16
RET


get_left_offvalue:
   push R16
   push YH
   push YL
   ldi YH, high(LEFT_OFF) 
   ldi YL, low(LEFT_OFF)
   SET_LEFT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   ;rcall delay_10ms
   GET_ADC_VALUE R16
   st Y,R16
   pop YL
   pop YH
   pop R16
RET


get_right_offvalue:
   push R16
   push YH
   push YL
   ldi YH, high(RIGHT_OFF)
   ldi YL, low(RIGHT_OFF)
   SET_RIGHT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   ;rcall delay_10ms
   GET_ADC_VALUE R16
   st Y,R16
   pop YL
   pop YH
   pop R16
RET


compare_left:
   push YL
   push YH
   push R16
   push R17
   ldi YH, high(LEFT_ON) ;set pointer to value with led on
   ldi YL, low(LEFT_ON)
   ld R17, Y ;load value of adc with led on
   ldi YH, high(LEFT_OFF); set pointer to value with led off
   ldi YL, low(LEFT_OFF)
   ld R16, Y ; load value of adc with led off
   sub  R17,R16 ;sub low first
   ldi YH, high(LEFT) 
   ldi YL, low(LEFT)
   st Y, R17 ; store low value
   pop R17
   pop R16
   pop YH
   pop YL
RET


compare_right:
   push YL
   push YH
   push R16
   push R17
   ldi YH, high(RIGHT_ON) ;set pointer to value with led on
   ldi YL, low(RIGHT_ON)
   ld R17, Y ;load value of adc with led on
   ldi YH, high(RIGHT_OFF); set pointer to value with led off
   ldi YL, low(RIGHT_OFF)
   ld R16, Y ; load value of adc with led off
   sub  R17,R16 ;sub low first
   ldi YH, high(RIGHT) 
   ldi YL, low(RIGHT)
   st Y, R17 ; store low value
   pop R17
   pop R16
   pop YH
   pop YL
RET


compare_left_right:
   push YL
   push YH
   push XL
   push XH
   push R17
   push R18
   ;push e(k-1) to e(k-2)
   ldi YH, high(ek_1_add)
   ldi YL, low(ek_1_add)
   ld R17, Y ;e(k-1) is in R17
   ldi XH, high(ek_2_add)
   ldi XL, low(ek_2_add)
   st X, R17 ;now e(k-1) is e(k-2)
   ldi XH, high(ek_add)
   ldi XL, low(ek_add)
   ld R17, X ;now load the old e(k) 
   st Y, R17 ;and write it to e(k-a) Y is still on ek_1_add
   ldi YH, high(LEFT)
   ldi YL, low(LEFT)
   ld R18, Y
   ldi YH, high(RIGHT)
   ldi YL, low(RIGHT)
   ld R17, Y
   andi MSREG, ~(1<<CP_EQU) ;clear the equal flag
   andi MSREG, ~(1<<CP_CARRY) ;clear the equal flag
   ;cp left-right->
   ;if carry set	-> left<right -> left is darker		-> right should be faster 
   ;if carry clear	-> left>right -> right is darker	-> left should be faster
   sub  R18,R17 ;R18=X
   ;now store e=w-x
   ldi R17, W ;R17=W
   sub R17,R18 ; R17 = e(k)
   ldi YL, low(ek_add)
   ldi YH, high(ek_add)
   st Y, R17 ;e(k) stored
   pop R18
   pop R17
   pop XH
   pop XL
   pop YH
   pop YL
RET


calculate_PID_controller:
;yk=y1+y2+y3+y4
   push R16
   push R17
   push R18
   push R19
   push R20
   push R21
   push R22
   push YL
   push YH


 get_Y1:  ;=y(k-1)
   ldi YL, low(Yk_add)
   ldi YH, high(Yk_add)
   ld R16, Y+ ;this loads Y(k), which is now Y(k-1)
   ld R17, Y+ ;because the address for Y1 is direkt after Yk no new address needs to be loaded
   ld R18, Y+
   ;now the pointer is on Y1_add
   st Y+, R16 ;1byte is low
   st Y+, R17 ;2byte is 
   st Y, R18
   
 get_Y2: ;=Ymult1*e(k)
   ldi YL,low(Y_Mult1_add) ;get Y_mult1
   ldi YH,high(Y_Mult1_add)
   ld R16, Y+ ;now the pointer is on y_mult1_add ;r16= low(y_mul1)
   ld R17, Y+ ; ;r17= high(y_mul1)
   ; pointer is on ek_add; r18=e(k)
   ld R18, Y+ 
   andi MSREG, ~(1<<N_SIGN) ;clear the sign if the result is negative or positive N_SEG=1 ->negative
   TST R18
   BRMI ek_neg ;if N is set e is negativ so the whole high byte needs to be ones
   rjmp get_Y2_continue1;else e is positive and the high byte needs to be zeros
  ek_neg:
   neg R18 ;2compl e(k)
   ldi R22,(1<<N_SIGN);remember you negated n18!
   EOR MSREG, R22 ;negate the N_SIGN bit in mystatusregister
  get_Y2_continue1:
   NEG_16bit R17, R16 ;negate Y_Mult1
   ldi R22,(1<<N_SIGN)
   EOR MSREG, R22 ;Y_Mult1 is negative
   rcall mul_16bitx8bit ;multiply to get Y2
   SBRC MSREG, N_SIGN ;skip if the result should be positive
   NEG_24bit R21,R20,R19 ;switch the sign of Y2 to negative
   ;pointer is now on Y2_add
   st Y+,R19 ;the pointer is on Y2_add so it is on the low address
   st Y+,R20 ;store middle
   st Y,R21 ;store high

 get_Y3: ;=ymul2*e(k-1)
   ldi YL,low(Y_Mult2_add) ;get Y_mult2
   ldi YH,high(Y_Mult2_add)
   ld R16, Y+ ;now the pointer is on y_mult2_add ;r16= low(y_mul2)
   ld R17, Y+ ; ;r17= high(y_mul2)
   ;pointer is now on e(k-1)
   ld R18, Y+ ; pointer is on ek_1_add; r18=e(k-1)
   andi MSREG, ~(1<<N_SIGN) ;clear the sign if the result is negative or positive N_SEG=1 ->negative
   TST R18
   BRMI ek_1_neg ;if N is set e is negativ so the whole high byte needs to be ones
   rjmp get_Y3_continue1;else e is positive and the high byte needs to be zeros
  ek_1_neg:
   neg R18
   ldi R22,(1<<N_SIGN)
   EOR MSREG, R22 ;negate the N_SIGN bit in mystatusregister
  get_Y3_continue1:
   ;mult2 is positive
   rcall mul_16bitx8bit ;multiply to get Y2
   SBRC MSREG, N_SIGN ;skip if the result should be positive
   NEG_24bit R21,R20,R19 ;switch the sign of Y2 to negative
   ;pointer is now on Y3_add
   st Y+,R19 ;the pointer is on Y2_add so it is on the low address
   st Y+,R20 ;store middle
   st Y,R21 ;store high


 get_Y4: ;=Kd*e(k-2)
   ldi YL,low(Kd_add) ;get Kd
   ldi YH,high(Kd_add)
   ld R16, Y+ ;now the pointer is on Kd_add ;r16= low(y_mul1)
   ld R17, Y+ ; ;r17= high(y_mul1)
   ;pointer is now on ek_2_add
   ld R18, Y+ ; pointer is on ek_2_add; r18=e(k-2)
   andi MSREG, ~(1<<N_SIGN) ;clear the sign if the result is negative or positive N_SEG=1 ->negative
   TST R18
   BRMI ek_2_neg ;if N is set e is negativ so the whole high byte needs to be ones
   rjmp get_Y4_continue1;else e is positive and the high byte needs to be zeros
  ek_2_neg:
   neg R18
   ldi R22,(1<<N_SIGN)
   EOR MSREG, R22 ;negate the N_SIGN bit in mystatusregister
  get_Y4_continue1:
   NEG_16bit R17, R16 ;negate Kd
   ldi R22,(1<<N_SIGN)
   EOR MSREG, R22 ;Kd is negative so neg statusbit
   rcall mul_16bitx8bit ;multiply to get Y2
   SBRC MSREG, N_SIGN ;skip if the result should be positive
   NEG_24bit R21,R20,R19 ;switch the sign of Y2 to negative
   st Y+,R19 ;the pointer is on Y2_add so it is on the low address
   st Y+,R20 ;store middle
   st Y+,R21 ;store high

 get_Yk: ;Y1+Y2+Y3+Y4
   ldi YH, high(Y1_add)
   ldi YL, low(Y1_add)
   ld R16, Y+
   ld R17, Y+
   ld R18, Y+ ;load Y1
   mov R19,R16
   mov R20, R17
   mov R21, R18 ;store it

   ;add Y2
   ldi YH, high(Y2_add)
   ldi YL, low(Y2_add)
   ld R16, Y+
   ld R17, Y+
   ld R18, Y+ ;load y2
   add R19, R16
   adc R20, R17
   adc R21, R18 ;add it
   
   ;add Y3
   ldi YH, high(Y3_add)
   ldi YL, low(Y3_add)
   ld R16, Y+
   ld R17, Y+
   ld R18, Y+ ;load y3
   add R19, R16
   adc R20, R17
   adc R21, R18 ;add it

   ;add Y4
   ldi YH, high(Y4_add)
   ldi YL, low(Y4_add)
   ld R16, Y+
   ld R17, Y+
   ld R18, Y+ ;load y4
   add R19, R16
   adc R20, R17
   adc R21, R18 ;add it

   ;store Yk
   ldi YH, high(Yk_add)
   ldi YL, low(Yk_add)
   st Y+, R19
   st Y+, R20
   st Y+, R21;store Yk

   

   pop YH
   pop YL
   pop R22
   pop R21
   pop R20
   pop R19
   pop R18
   pop R17
   pop R16
RET


mul_16bitx8bit: ;multiplies R17:R16 x R18 and writes it to R21:R20:R19 just unsigned!! so if you have signed change them to unsigned(neg,+1) and store the sign(+*+=+, +*-=- bla bla)  
   push R2
   clr R2
   MUL R16, R18 ;value is in R1:R0
   MOV R19, R0
   MOV R20, R1
   MUL R17, R18
   MOV R21, R1
   ADD R20, R0
   ADC R21, R2
   pop R2
RET