.include "m8def.inc"

;############## M A C R O S ###########################

 .macro ADDI
   subi @0,-@1
 .endm

 .macro SWITCH_LEFT_BACKLED_ON
   SBI PORTC, PC1
 .endm

 .macro SWITCH_LEFT_BACKLED_OFF
   CBI PORTC, PC1
 .endm

 .macro SWITCH_RIGHT_BACKLED_ON
   SBI PORTC, PC0
 .endm

 .macro SWITCH_RIGHT_BACKLED_OFF
   CBI PORTC, PC0
 .endm

 .macro SWITCH_TOPLED_ON
   SBI PORTD, PD6
 .endm

 .macro SWITCH_TOPLED_OFF
   CBI PORTD, PD6
 .endm

 .macro TRANSMIT
   CBI UCSRB, RXEN ;clear RXEN
   SBI UCSRB, TXEN ;set TXEN 
   wait_transmit:
     SBIS UCSRA, UDRE ;//skip next instuction if dataregister is empty
     rjmp wait_transmit //if UDRE=0 it will wait
   out UDR, @0;put the value from R16 to UDR to send the data
 .endm

 .macro RECIEVE
  CBI UCSRB, TXEN ;clear TXEN 
  SBI UCSRB, RXEN ;set RXEN
  recieve_data:
    SBIS UCSRA, RXC ;//skip next inst if RevieveComplete
    rjmp recieve_data //if RSC=0 it will wait
  in @0, UDR
 .endm

 .macro SET_LEFT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   push R16
   ldi R16, (1 << REFS0)|(1 << MUX0)|(1 << MUX1)|(1 << ADLAR);set ADC2 to source
   out ADMUX, R16
   pop R16
 .endm

 .macro SET_RIGHT_PHOTOTRANSINSTR_TO_ADC_SOURCE
   push R16
   ldi R16, (1 << REFS0)|(1 << MUX1)|(1 << ADLAR);set ADC3 to source
   out ADMUX, R16
   pop R16
 .endm

 .macro SET_BUMPER_TO_ADC_SOURCE
   push R16 ;save R16
   ldi R16, (1 << REFS0)|(1 << MUX2)|(1 << ADLAR);set ADC4 to source
   out ADMUX, R16 ;send the definition to ADMUS
   pop R16; restore R16
 .endm

 .macro GET_ADC_VALUE
   SBI ADCSRA, ADSC ;start adc converter
   get_value: ;wait till value is ready
     SBIS ADCSRA, ADIF ;adif is set if the converter finished
     rjmp get_value
   in @0, ADCH ;high to first register
 .endm

 .macro MotorDir_FWD_FWD
   SBI PortD,PD5 ;left forward
   CBI PortD,PD4 ;left forward
   SBI PortB,PB5 ;right forward
   CBI PortB,PB4 ;right forward
 .endm

 .macro MotorDir_RWD_RWD
   CBI PortD,PD5 ;right backward
   SBI PortD,PD4 ;right backward
   CBI PortB,PB5 ;right backward
   SBI PortB,PB4 ;right backward
 .endm

 .macro MotorDir_FWD_RWD
   SBI PortD,PD5 ;left forward
   CBI PortD,PD4 ;left forward
   CBI PortB,PB5 ;right backward
   SBI PortB,PB4 ;right backward
 .endm

 .macro MOTOR_BREAK
   CBI PortD,PD5 ;left stop
   CBI PortD,PD4 ;left stop
   CBI PortB,PB5 ;right stop
   CBI PortB,PB4 ;right stop
 .endm

 .macro NEG_16bit
   push R1
   clr R1 ;R16=0
   com @0 ;high
   com @1 ;low
   addi @1,1 ;add 1 to the low byte
   adc @0,R1 ;just add the carry (r16=0) to the high bit
   pop R1
 .endm

 .macro NEG_24bit
   push R1
   clr R1 ;R16=0
   com @0 ;high
   com @1 ;middle
   com @2 ;low
   addi @2,1 ;add 1 to the low byte
   adc @1,R1 ;just add the carry (r16=0) to the middle bit
   adc @0,R1 ;add carry to high byte
   pop R1
 .endm


