
/*********************************************************************************************************
*
*	Description:	Very basic program that sends a control sequence to a remote control outlet
*					Sehr einfaches Programm, das eine Steuersequenz an eine Funksteckdose sendet
*
*					This program is just a feasability study that shows how to employ an RFM12
*					to switch a remote control outlet using OOK modulation (On-/Off keying)
*
*					Das Programm ist lediglich eine Machbarkeitsstudie, die aufzeigt, wie man
*					RFM12-Module verwendet, um per OOK-Modulation (On-/Off keying)  Funksteck-
*					dosen zu schalten.
*
*	Hardware:		AVR Funkevaluationsboard from Pollin
*					Atmega8L using a 12MHz external crystal osc., 
*					RFM12 radio module  (433 MHz - version)
*
*	Software		IDE:  AVR Studio 4.19 Build 716, 
*					using external gcc compiler from WinAVR
*
*	Readings:		http://www.mikrocontroller.net/topic/298868		# program was first published here
*					http://avr.brke.de/Funksteckdosen.htm			# explains coding sequence schema
*					http://www.firefly-power.de/ARM/RFM12.html		# good init-sequence for rfm12
*
*					http://www.mikrocontroller.net/articles/RFM12   # RFM12 basics
*					http://www.mikrocontroller.net/topic/65984		# part of this code is based on
*																	# benedikt's code
*
**********************************************************************************************************/



#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include "global.h"
#include "rf12.h"  


#define F_CPU 12000000UL
#include <util/delay.h>

void send(void);
void receive(void);
void sendOOK();
void bit0(void);
void bit1(void);
void sync(void);




int main(void)
{

	rf12_init();			// init a few registers (e.g. CLK -> 10MHz)
	sei();

	for (int i=0;i<5;i++)
	{
		sendOOK();
	}
}






// Sequence to switch on my remote control outlet (dt.: Funksteckdose):
// Adopt this sequence for your remote control outlet  
//
// See:  http://avr.brke.de/Funksteckdosen.htm
//
// *****************************************************
// * Systemcode     * Outlet A ... E * On / Off *      *
// * 00 01 01 00 01 * 01 01 00 01 01 * 00 01    * syn  *
// *****************************************************

void sendOOK(void)
{	
	bit0();
	bit0();

	bit0();
	bit1();

	bit0();
	bit1();

	bit0();
	bit0();

	bit0();
	bit1();

	// *

	bit0();
	bit1();

	bit0();
	bit1();

	bit0();
	bit0();

	bit0();
	bit1();

	bit0();
	bit1();

	// *

	bit0();		// For to switch off:	bit0();
	bit0();		// For to switch off:   bit1();

	bit0();		// For to switch off:	bit0();
	bit1();		// For to switch off:	bit0();

	// *

	sync();
}



// Define length of pulse (us) - you may have to adjust this value slightly for your rc outlet
#define pulse 290


void bit0(void)
{
	rf12_trans(0x8220);			// TX on/
	_delay_us(pulse);
	
	rf12_trans(0x8200);			// TX off
	_delay_us(3*pulse);
}



void bit1(void)
{
	rf12_trans(0x8220);			// TX on
	_delay_us(3*pulse);

	rf12_trans(0x8200);			// TX off
	_delay_us(pulse);
}


void sync(void)
{
	rf12_trans(0x8220);			// TX on
	_delay_us(pulse);

	rf12_trans(0x8200);			// TX off
	_delay_us(31*pulse);
}
