#include <avr/io.h>
#include <avr/interrupt.h>
#include "global.h"
#include "rf12.h"

#define F_CPU 12000000UL
#include <util/delay.h>


#define RF_PORT	PORTB
#define RF_DDR	DDRB
#define RF_PIN	PINB

#define SDI		3
#define SCK		5
#define CS		2
#define SDO		4

/*
Funkmodule	Tiny 2313	Mega 8 			Mega16/32		Benedikt Beschaltung
------------------------------------------------------------------------------
NINT 		PB0 (AIN0)	PB0 (ICP)		PB0 (T0)		-
DCLK 		PD3 (INT1) 	PD3 (INT1) 		PD3 (INT)		-
SDO 		PB6 (MISO) 	PB4 (MISO) 		PB6 (MISO)		PB4 (MISO)
FSK 		PB3 (OCI) 	PD7 (AINT) 		PB3 (AIN1)		--1kOhm--> +5V 
NIRQ 		PD2 (INT0) 	PD2 (INT0) 		PD (INT0)		-
NSEL 		PB4 		PB2 (SS/OC1B) 	PB4 (SS)		PB2 (SS/OC1B)
SCK 		PB7 (SCK) 	PB5 (SCK) 		PB7 (SCK)		PB5 (SCK)
SDI 		PB5 (MOSI) 	PB3 (MOSI/OC) 	PB5 (MOSI)		PB3 (MOSI/OC)
VCC 		VCC 		VCC 			VCC				VCC
*/


unsigned short rf12_trans(unsigned short wert)
{	unsigned char i;

	cbi(RF_PORT, CS);
	for (i=0; i<16; i++)
	{	if (wert&32768)
			sbi(RF_PORT, SDI);
		else
			cbi(RF_PORT, SDI);
		wert<<=1;
		if (RF_PIN&(1<<SDO))
			wert|=1;
		sbi(RF_PORT, SCK);
		asm("nop");
		asm("nop");
		cbi(RF_PORT, SCK);
	}
	sbi(RF_PORT, CS);
	return wert;
}




void rf12_init(void)
{
	RF_DDR=(1<<SDI)|(1<<SCK)|(1<<CS);
	RF_PORT=(1<<CS);

	for (unsigned char i=0; i<50; i++)
		_delay_ms(10);			// wait until POR done

   rf12_trans(0x8017); // disable FIFO, 433MHz, 12.0pF
   rf12_trans(0x8208); // synth off, PLL off, enable xtal, enable clk pin, disable Batt
   rf12_trans(0xA620); //   (0xA620 433.92MHz)
   rf12_trans(0xC647); // c647 4.8Kbps (38.4: 8, 19.2: 11, 9.6: 23, 4.8: 47)
   rf12_trans(0x9489); // VDI,FAST,BW200kHz,-6dBm,DRSSI -97dbm
   rf12_trans(0xC220); // datafiltercommand ; ** not documented command **
   rf12_trans(0xCA00); // FiFo and resetmode command ; FIFO fill disabeld
   rf12_trans(0xC4C3); // enable AFC ;enable frequency offset
   rf12_trans(0xCC67); //
   rf12_trans(0xC000); // clock output 1.00MHz, can be used to see if SPI works
   rf12_trans(0xE000); // disable wakeuptimer
   rf12_trans(0xC800); // disable low duty cycle
}



