library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity Counter4Bits is
port (
  Clock       : in STD_LOGIC;
  Reset       : in STD_LOGIC;
  Enable       : in STD_LOGIC; 
  Cnt       : out STD_LOGIC_VECTOR(3 downto 0)
);
end Counter4Bits;

architecture Counter4Bits_arch of Counter4Bits is

signal counter : unsigned(3 downto 0);
  
begin
   process (Clock,Reset,counter)
   begin
      if (Reset = '1') then
     counter <= (others => '0');
      elsif (rising_edge(Clock)) then
            if (Enable = '1') then    
               counter <= counter + 1;
            end if;
      --if (counter >= "1001") then
      --   counter <= (others => '0');
      --end if;
      end if;  

      Cnt <= std_logic_vector(counter);

   end process;

end Counter4Bits_arch;
