#ifndef _main_h_
#define _main_h_


#include 	<avr/io.h>
#include 	<stdlib.h>
#include 	<stdint.h>
#include 	<inttypes.h>
#include 	<stdio.h>
#include 	<avr/interrupt.h>
#include 	<util/delay.h>
#include 	<avr/eeprom.h>
#include 	<avr/pgmspace.h>
#include 	<string.h>
#include	 <math.h>
#include	 <avr/wdt.h>
#include <util/atomic.h>







#include "1WIRE.h"
#include "DELAY.h"
#include "TEMPMEAS.h"


#include "uart.h"


//#include "timebase.h"
//#include <avr/signal.h>

//#define XTAL 11.0592e6
//#define F_CPU 14.7456e6

#define TIMERTICK	(F_CPU / 256 / 256)	// timer ticks per second

#define SECONDS(x)	((t_res)(TIMERTICK * x + 0.5))

#define uchar unsigned char
#define uint unsigned int
#define lint uint32_t
#define bit uint8_t
//

#define idata
#define code




//#define idata
//#define code

typedef void ( *funcp)(void);

//#define t_res		uchar		// define time resolution  8 bit
//#define t_res		uint		// define time resolution 16 bit
#define t_res		lint		// define time resolution 32 bit


#define KEY_INPUT	PINC

#define LED_OUTPUT	PORTB
#define LED0		PB0
#define LED1		PB1
#define LED2		PB2
#define LED3		PB3
#define LED4		PB4


extern uchar key_state;		// debounced and inverted key state:
				// bit = 1: key pressed
extern uchar key_press;		// key press detect or repeat

extern uchar f_timer_tick;	// timer flag

extern uchar volatile second;










extern uchar get_key_press( uchar key_mask );

void timertick(void);

bit timeradd( funcp func, t_res delay );

bit timerremove( funcp func );

void timerinit(void);

#define XTAL		14745600L

#define	BAUD	9600
#define bauddivider (uint)(1.0 * XTAL / BAUD / 16 - 0.5)





#define W1_PIN	PD6
#define W1_IN	PIND
#define W1_OUT	PORTD
#define W1_DDR	DDRD

#endif