#include "MAIN.h"


void start_meas( void )
{
	if( W1_IN & 1<< W1_PIN )
	{
		w1_command( CONVERT_T, NULL );
		W1_OUT |= 1<< W1_PIN;
		W1_DDR |= 1<< W1_PIN;			// parasite power on
	}
	else
	{
		uputsnl( "Short Circuit !" );
	}
}

// Meine test funktion

void Mein_start_meas(uint8_t id[])
{
	if( W1_IN & 1<< W1_PIN )
	{
		w1_command( CONVERT_T, id );
		W1_OUT |= 1<< W1_PIN;
		W1_DDR |= 1<< W1_PIN;			// parasite power on
	}
	else
	{
		uputsnl( "Short Circuit !" );
	}
}



void read_meas( void )
{
  uchar id[8], diff;
  char s[30];
  uchar i;
  uint temp;

  for( diff = SEARCH_FIRST; diff != LAST_DEVICE; )
  {
		diff = w1_rom_search( diff, id );
		if( diff == PRESENCE_ERR )
		{
			uputsnl( "No Sensor found" );
			break;
		 }
		if( diff == DATA_ERR )
		{
			uputsnl( "Bus Error" );
			break;
		}
		if( id[0] == 0x28 || id[0] == 0x10 )// temperature sensor
		{	
			uputs( "ID: " );
			for( i = 0; i < 8; i++ )
			{
				sprintf( s, "%02X ", id[i] );
				uputs( s );
			}
			w1_byte_wr( READ );			// read command
			temp = w1_byte_rd();			// low byte
			temp |= (uint)w1_byte_rd() << 8;		// high byte
			if( id[0] == 0x10 )			// 9 -> 12 bit
			{
				temp <<= 3;
			}
			sprintf( s, "  T: %04X = ", temp );	// hex value
			uputs( s );
			sprintf( s, "%4d.%01dC\n\r", temp >> 4, (temp << 12) / 6553 ); // 0.1C
			uputs( s );
		}
  }
  uputsnl( "" );
}
void Mein_read_meas( void )
{
	uchar id[8]={0x10,0xdc,0x39,0x39,0x02,0x08,0x00,0xD7};

	char s[30];
	
	uint temp;
	//w1_byte_wr( READ );			// read command
	
	w1_command( READ, id );
	temp = w1_byte_rd();			// low byte
	temp |= (uint)w1_byte_rd() << 8;		// high byte
	if( id[0] == 0x10 )			// 9 -> 12 bit
	{
		temp <<= 3;
	}
	sprintf( s, "  T: %04X = ", temp );	// hex value
	uputs( s );
	sprintf( s, "%4d.%01dC\n\r", temp >> 4, (temp << 12) / 6553 ); // 0.1C
	uputs( s );
	
	uputsnl( "" );
}

//ow_reset(); //**
	//ow_command(DS18X20_READ, id);
	//for ( i=0 ; i< DS18X20_SP_SIZE; i++ ) sp[i]=ow_byte_rd();