#include "main.h"


void uinit( void )
{
  UBRR0L = bauddivider;			//set baud rate
  UBRR0H = bauddivider >> 8;
  UCSR0A = 0;				//no U2X, MPCM
  UCSR0C = 1<<UCSZ01^1<<UCSZ00;	//8 Bit
  UCSR0B = 1<<RXEN0^1<<TXEN0;		//enable RX, TX
}


void uputchar( char c )
{
  while( (UCSR0A & 1<<UDRE0) == 0 );
  UDR0 = c;
}


void uputs( char *s )
{
  while( *s )
    uputchar( *s++ );
}


void uputsnl( char *s )
{
  uputs( s );
  uputchar( 0x0D );
}
