--
--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 
--
--   To use any of the example code shown below, uncomment the lines and modify as necessary
--

library IEEE;
use IEEE.STD_LOGIC_1164.all;

package COMPONENTS_PACKAGE is


--******************************************************
-- Components definition
--******************************************************

--+++++++++++++++++++++++++++++++++++++++
-- only for testing without RAM Memory Controller
COMPONENT PLL_DDR_SYSTEM_CLK
	PORT(
		CLKIN1_IN : IN std_logic;        -- 50MHz 
		RST_IN : IN std_logic;  
		CLKOUT0_OUT : OUT std_logic;		-- 133,333MHz
		CLKOUT1_OUT : OUT std_logic;		-- 200MHz
		CLKOUT2_OUT : OUT std_logic;		-- 266,667MHz
		LOCKED_OUT : OUT std_logic
		);
	END COMPONENT;

--------------------------------------------------------
--	RAM Adress counter 
--------------------------------------------------------

COMPONENT RAM_ADSRESS_COUNT
	PORT(
		reset : IN std_logic;
		clk : IN std_logic;
		count_en : IN std_logic;
		FIFO_full : IN std_logic;
		bank_adr : IN std_logic_vector(2 downto 0);          
		rd_enable : OUT std_logic;
		ram_adress : OUT std_logic_vector(30 downto 0)
		);
	END COMPONENT;

--------------------------------------------------------
--	Pixel row FIFO
--------------------------------------------------------

COMPONENT PIXEL_ROW_FIFO
  PORT (
    clk : IN STD_LOGIC;
    rst : IN STD_LOGIC;
    din : IN STD_LOGIC_VECTOR(47 DOWNTO 0);
    wr_en : IN STD_LOGIC;
    rd_en : IN STD_LOGIC;
    dout : OUT STD_LOGIC_VECTOR(47 DOWNTO 0);
    full : OUT STD_LOGIC;
    empty : OUT STD_LOGIC;
	 valid : OUT STD_LOGIC;
    prog_empty : OUT STD_LOGIC
  );
END COMPONENT;


--------------------------------------------------------
--	Serial to parallel converter
--------------------------------------------------------

COMPONENT SERIAL_PARALLEL_CONVERTER
	PORT(
		ram_pixel_data_in : IN std_logic_vector(31 downto 0);
		rd_data_valid : IN std_logic;
		reset : IN std_logic;
		clk : IN std_logic;          
		data_valid : OUT std_logic;
		ram_pixel_data_out : OUT std_logic_vector(47 downto 0)
		);
	END COMPONENT;



--------------------------------------------------------
--	DDR Memory Controller 
--------------------------------------------------------

component MEMORY_CONTROLLER_TEST
 generic(
     BANK_WIDTH               : integer := 3;    
                              -- # of memory bank addr bits.
     CKE_WIDTH                : integer := 1;    
                              -- # of memory clock enable outputs.
     CLK_WIDTH                : integer := 1;    
                              -- # of clock outputs.
     COL_WIDTH                : integer := 10;    
                              -- # of memory column bits.
     CS_NUM                   : integer := 1;    
                              -- # of separate memory chip selects.
     CS_WIDTH                 : integer := 1;    
                              -- # of total memory chip selects.
     CS_BITS                  : integer := 0;    
                              -- set to log2(CS_NUM) (rounded up).
     DM_WIDTH                 : integer := 2;    
                              -- # of data mask bits.
     DQ_WIDTH                 : integer := 16;    
                              -- # of data width.
     DQ_PER_DQS               : integer := 8;    
                              -- # of DQ data bits per strobe.
     DQS_WIDTH                : integer := 2;    
                              -- # of DQS strobes.
     DQ_BITS                  : integer := 4;    
                              -- set to log2(DQS_WIDTH*DQ_PER_DQS).
     DQS_BITS                 : integer := 1;    
                              -- set to log2(DQS_WIDTH).
     ODT_WIDTH                : integer := 1;    
                              -- # of memory on-die term enables.
     ROW_WIDTH                : integer := 13;    
                              -- # of memory row and # of addr bits.
     ADDITIVE_LAT             : integer := 0;    
                              -- additive write latency.
     BURST_LEN                : integer := 4;    
                              -- burst length (in double words).
     BURST_TYPE               : integer := 0;    
                              -- burst type (=0 seq; =1 interleaved).
     CAS_LAT                  : integer := 4;    
                              -- CAS latency.
     ECC_ENABLE               : integer := 0;    
                              -- enable ECC (=1 enable).
     APPDATA_WIDTH            : integer := 32;    
                              -- # of usr read/write data bus bits.
     MULTI_BANK_EN            : integer := 1;    
                              -- Keeps multiple banks open. (= 1 enable).
     TWO_T_TIME_EN            : integer := 0;    
                              -- 2t timing for unbuffered dimms.
     ODT_TYPE                 : integer := 3;    
                              -- ODT (=0(none),=1(75),=2(150),=3(50)).
     REDUCE_DRV               : integer := 1;    
                              -- reduced strength mem I/O (=1 yes).
     REG_ENABLE               : integer := 0;    
                              -- registered addr/ctrl (=1 yes).
     TREFI_NS                 : integer := 7800;    
                              -- auto refresh interval (ns).
     TRAS                     : integer := 40000;    
                              -- active->precharge delay.
     TRCD                     : integer := 15000;    
                              -- active->read/write delay.
     TRFC                     : integer := 127500;    
                              -- refresh->refresh, refresh->active delay.
     TRP                      : integer := 15000;    
                              -- precharge->command delay.
     TRTP                     : integer := 7500;    
                              -- read->precharge delay.
     TWR                      : integer := 15000;    
                              -- used to determine write->precharge.
     TWTR                     : integer := 7500;    
                              -- write->read delay.
     HIGH_PERFORMANCE_MODE    : boolean := TRUE;    
                              -- # = TRUE, the IODELAY performance mode is set
                              -- to high.
                              -- # = FALSE, the IODELAY performance mode is set
                              -- to low.
     SIM_ONLY                 : integer := 0;    
                              -- = 1 to skip SDRAM power up delay.
     DEBUG_EN                 : integer := 0;    
                              -- Enable debug signals/controls.
                              -- When this parameter is changed from 0 to 1,
                              -- make sure to uncomment the coregen commands
                              -- in ise_flow.bat or create_ise.bat files in
                              -- par folder.
     CLK_PERIOD               : integer := 7500;    
                              -- Core/Memory clock period (in ps).
     DLL_FREQ_MODE            : string := "HIGH";    
                              -- DCM Frequency range.
     CLK_TYPE                 : string := "SINGLE_ENDED";    
                              -- # = "DIFFERENTIAL " ->; Differential input clocks ,
                              -- # = "SINGLE_ENDED" -> Single ended input clocks.
     NOCLK200                 : boolean := FALSE;    
                              -- clk200 enable and disable
     RST_ACT_LOW              : integer := 1     
                              -- =1 for active low reset, =0 for active high.
);
    port (
   ddr2_dq               : inout  std_logic_vector((DQ_WIDTH-1) downto 0);
   ddr2_a                : out   std_logic_vector((ROW_WIDTH-1) downto 0);
   ddr2_ba               : out   std_logic_vector((BANK_WIDTH-1) downto 0);
   ddr2_ras_n            : out   std_logic;
   ddr2_cas_n            : out   std_logic;
   ddr2_we_n             : out   std_logic;
   ddr2_cs_n             : out   std_logic_vector((CS_WIDTH-1) downto 0);
   ddr2_odt              : out   std_logic_vector((ODT_WIDTH-1) downto 0);
   ddr2_cke              : out   std_logic_vector((CKE_WIDTH-1) downto 0);
   ddr2_dm               : out   std_logic_vector((DM_WIDTH-1) downto 0);
   sys_clk               : in    std_logic;
   idly_clk_200          : in    std_logic;
   sys_rst_n             : in    std_logic;
   phy_init_done         : out   std_logic;
   rst0_tb               : out   std_logic;
   clk0_tb               : out   std_logic;
   app_wdf_afull         : out   std_logic;
   app_af_afull          : out   std_logic;
   rd_data_valid         : out   std_logic;
   app_wdf_wren          : in    std_logic;
   app_af_wren           : in    std_logic;
   app_af_addr           : in    std_logic_vector(30 downto 0);
   app_af_cmd            : in    std_logic_vector(2 downto 0);
   rd_data_fifo_out      : out   std_logic_vector((APPDATA_WIDTH-1) downto 0);
   app_wdf_data          : in    std_logic_vector((APPDATA_WIDTH-1) downto 0);
   app_wdf_mask_data     : in    std_logic_vector((APPDATA_WIDTH/8-1) downto 0);
   ddr2_dqs              : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_dqs_n            : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_ck               : out   std_logic_vector((CLK_WIDTH-1) downto 0);
   ddr2_ck_n             : out   std_logic_vector((CLK_WIDTH-1) downto 0)
);
end component;

--******************************************************
-- End Components definition
--******************************************************



 constant    BANK_WIDTH               : integer := 3;    	-- # of memory bank addr bits.
 constant    CKE_WIDTH                : integer := 1;    	-- # of memory clock enable outputs.
 constant    CLK_WIDTH               : integer := 1;    	-- # of clock outputs.
 constant    COL_WIDTH                : integer := 10;   	-- # of memory column bits.
 constant    CS_NUM                    : integer := 1;    	-- # of separate memory chip selects.
 constant    CS_WIDTH                 : integer := 1;    	-- # of total memory chip selects.
 constant     CS_BITS                 : integer := 0;   		-- set to log2(CS_NUM) (rounded up).
 constant     DM_WIDTH                : integer := 2;   		-- # of data mask bits.
 constant   DQ_WIDTH                  : integer := 16;    	-- # of data width.
 constant   DQ_PER_DQS                : integer := 8;     	-- # of DQ data bits per strobe.
 constant   DQS_WIDTH                 : integer := 2;     	-- # of DQS strobes.
 constant   DQ_BITS                   : integer := 4;     	-- set to log2(DQS_WIDTH*DQ_PER_DQS).
 constant    DQS_BITS                 : integer := 1;    	-- set to log2(DQS_WIDTH).
 constant    ODT_WIDTH                : integer := 1;    	-- # of memory on-die term enables.
 constant    ROW_WIDTH                : integer := 13;		-- # of memory row and # of addr bits.
 constant    ADDITIVE_LAT             : integer := 0;    	-- additive write latency.
 constant    BURST_LEN                : integer := 4;    	-- burst length (in double words).
 constant    BURST_TYPE               : integer := 0;    	-- burst type (=0 seq; =1 interleaved).
 constant    CAS_LAT                  : integer := 3;    	-- CAS latency.
 constant    ECC_ENABLE               : integer := 0;    	-- enable ECC (=1 enable).
 constant    APPDATA_WIDTH            : integer := 32;   	-- # of usr read/write data bus bits.
 constant    MULTI_BANK_EN            : integer := 1;    	-- Keeps multiple banks open. (= 1 enable).
 constant    TWO_T_TIME_EN            : integer := 0;    	-- 2t timing for unbuffered dimms.
 constant    ODT_TYPE                 : integer := 3;    	-- ODT (=0(none),=1(75),=2(150),=3(50)).
 constant    REDUCE_DRV               : integer := 1;    	-- reduced strength mem I/O (=1 yes).
 constant    REG_ENABLE               : integer := 0;    	-- registered addr/ctrl (=1 yes).
 constant    TREFI_NS                 : integer := 7800; 	-- auto refresh interval (ns).
 constant    TRAS                     : integer := 40000;	-- active->precharge delay.
 constant    TRCD                     : integer := 15000;	-- active->read/write delay.
 constant    TRFC                     : integer := 127500;	-- refresh->refresh, refresh->active delay.
 constant    TRP                      : integer := 15000; 	-- precharge->command delay.
 constant    TRTP                     : integer := 7500;    -- read->precharge delay.
 constant    TWR                      : integer := 15000;	-- used to determine write->precharge.
 constant    TWTR                     : integer := 7500;    -- write->read delay.
 constant    HIGH_PERFORMANCE_MODE    : boolean := TRUE;    -- # = TRUE, the IODELAY performance mode is set
																				-- to high.
																				-- # = FALSE, the IODELAY performance mode is set
																				-- to low.
 constant    SIM_ONLY                 : integer := 0;    	-- = 1 to skip SDRAM power up delay.
 constant    DEBUG_EN                 : integer := 1;    		-- Enable debug signals/controls.
																				-- When this parameter is changed from 0 to 1,
                              										-- make sure to uncomment the coregen commands
                              										-- in ise_flow.bat or create_ise.bat files in
                              										-- par folder.
 constant    CLK_PERIOD               : integer := 7500;    -- Core/Memory clock period (in ps).
 constant    DLL_FREQ_MODE            : string := "HIGH";   -- DCM Frequency range.
 constant    CLK_TYPE                 : string := "SINGLE_ENDED";    -- # = "DIFFERENTIAL " ->; Differential input clocks ,
																							-- # = "SINGLE_ENDED" -> Single ended input clocks.
 constant    NOCLK200                 : boolean := FALSE;    -- clk200 enable and disable
 constant    RST_ACT_LOW              : integer := 1;     	 -- =1 for active low reset, =0 for active high.


end COMPONENTS_PACKAGE;

package body COMPONENTS_PACKAGE is

---- Example 1
--  function <function_name>  (signal <signal_name> : in <type_declaration>  ) return <type_declaration> is
--    variable <variable_name>     : <type_declaration>;
--  begin
--    <variable_name> := <signal_name> xor <signal_name>;
--    return <variable_name>; 
--  end <function_name>;

---- Example 2
--  function <function_name>  (signal <signal_name> : in <type_declaration>;
--                         signal <signal_name>   : in <type_declaration>  ) return <type_declaration> is
--  begin
--    if (<signal_name> = '1') then
--      return <signal_name>;
--    else
--      return 'Z';
--    end if;
--  end <function_name>;

---- Procedure Example
--  procedure <procedure_name>  (<type_declaration> <constant_name>  : in <type_declaration>) is
--    
--  begin
--    
--  end <procedure_name>;
 
end COMPONENTS_PACKAGE;
