----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:58:38 07/01/2013 
-- Design Name: 
-- Module Name:    RAM_ADSRESS_COUNT - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_unsigned.all;
use ieee.std_logic_arith.all;
use ieee.numeric_std.all;


-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
-- use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
-- library UNISIM;
-- use UNISIM.VComponents.all;

entity RAM_ADSRESS_COUNT is
	 Port ( reset : 		in  STD_LOGIC;
           clk : 			in  STD_LOGIC;
           count_en : 	in  STD_LOGIC;
			  FIFO_full:	in	 STD_LOGIC;
			  bank_adr:		in	 STD_LOGIC_VECTOR(2 downto 0);
			  rd_enable:	out STD_LOGIC;
			  ram_adress:	out STD_LOGIC_VECTOR(30 downto 0)
);
end RAM_ADSRESS_COUNT;

architecture Behavioral of RAM_ADSRESS_COUNT is
signal t_ram_adress: STD_LOGIC_VECTOR(22 downto 0) := (others => '0');
begin
	
	ram_adress <= "11111" & bank_adr & t_ram_adress;
	
	
	RD_EN: process(count_en,FIFO_full)
	begin
		if reset = '1' then
			rd_enable <= '0';
		elsif (count_en = '1' and FIFO_full = '0') then
			rd_enable <= '1';
		else
			rd_enable <= '0';
		end if;
	
	end process RD_EN;
	
	ADR_COUNT: process(clk,reset,count_en,FIFO_full)
	begin
		if reset = '1' then
			t_ram_adress	<= "111" & x"fffff";
			--rd_enable <= '0';
		elsif clk'event and clk = '1' then
			if (count_en = '1' and FIFO_full = '0') then
				t_ram_adress <= t_ram_adress + 2;	
			end if;
		end if;
	end process ADR_COUNT;


end Behavioral;

