----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    08:57:58 07/01/2013 
-- Design Name: 
-- Module Name:    SERIAL_PARALLEL_CONVERTER - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity SERIAL_PARALLEL_CONVERTER is
	port(
			  ram_pixel_data_in:	 	in		STD_LOGIC_VECTOR(31 downto 0);
			  rd_data_valid:			in		STD_LOGIC;
			  reset:						in		STD_LOGIC;
           clk:						in	 	STD_LOGIC;
			  data_valid:				out	STD_LOGIC;
			  
--			  ram_pixel0_data_out:	out	STD_LOGIC_VECTOR (11 downto 0);
--			  ram_pixel1_data_out:	out	STD_LOGIC_VECTOR (11 downto 0);
--			  ram_pixel2_data_out:	out	STD_LOGIC_VECTOR (11 downto 0);
			  ram_pixel_data_out:	out	STD_LOGIC_VECTOR (47 downto 0)
	);
end SERIAL_PARALLEL_CONVERTER;

architecture Behavioral of SERIAL_PARALLEL_CONVERTER is
signal t_clk_en:		STD_LOGIC := '0';
signal t_clk_en_1:		STD_LOGIC := '0';
signal t_clk_en_2:		STD_LOGIC := '0';
signal t_ram_pix:	STD_LOGIC_VECTOR(31 downto 0) := (others => '0'); 
begin
	
	
	data_valid <= t_clk_en_2;
	
	DV_DELAY: process(clk,t_clk_en)
	begin
		t_clk_en_1 <= t_clk_en;
		t_clk_en_2 <= t_clk_en_1;
		
	end process DV_DELAY;
	
	SP:	process(clk,reset,rd_data_valid,t_clk_en)
		begin
			if reset = '1' then
				t_clk_en <= '0';
				t_ram_pix <= (others => '0');
			elsif clk'event and clk = '1' then
				if rd_data_valid = '1' and t_clk_en = '0' then
					t_ram_pix <= ram_pixel_data_in;
					t_clk_en <= '1';
				elsif rd_data_valid = '1' and t_clk_en = '1' then
					ram_pixel_data_out(23 downto 0) <= t_ram_pix(27 downto 16) & t_ram_pix(11 downto 0);
					ram_pixel_data_out(47 downto 24) <= ram_pixel_data_in(27 downto 16) & ram_pixel_data_in(11 downto 0);
					t_clk_en <= '0';
				end if;
			end if;
		end process SP;
end Behavioral;

