----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    13:57:02 06/18/2013 
-- Design Name: 
-- Module Name:    TOP_DESIGN - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
--use work.DDR_PACKAGE.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity TOP_DESIGN is
	port(	
			clk_ext:			in		STD_LOGIC;
			clk_DVI:			in		std_logic;
			ext_reset:			in		std_logic;
			
			-- DVI FIFO
			dvi_bus_in:				in		STD_LOGIC_VECTOR(53 downto 0);
			
			-- RAM Row FIFO
			test_dout:				out	STD_LOGIC_VECTOR(47 downto 0);
--			test_ram_adr:			out	STD_LOGIC_VECTOR(30 downto 0);
			test_dvi_full:			out	std_logic;
			test_fifo_dw_count:	out	STD_LOGIC_VECTOR(9 downto 0);
--			test_dvi_bus_delay:	out	STD_LOGIC_VECTOR(47 downto 0);
			test_fifo_dr_count:	out	STD_LOGIC_VECTOR(9 downto 0);
			test_rd_en_DVI_FIFO: in		std_logic;
			test_rd_en_RP_FIFO:	in		std_logic;
			test_dvi_wr_en:		in		std_logic;
			--test_dvi_rd_en:	in		std_logic;
			
		--	test_data_valid_SP:	out	std_logic
			
--			test_clk_ibufg:			out	std_logic;
--			test_ddr_reset:			in		std_logic;
			test_ddr_wdf_full:		out	std_logic;
			test_test_ddr_af_full:			out	std_logic;
			test_ddr_init_done:		out	std_logic;
			test_ddr_reset_uif:		out	std_logic;
			--test_rdqs_n:				out	std_logic_vector((DQS_WIDTH-1) downto 0);
--			test_ddr_rd_valid:		out	std_logic;
			test_ddr_clk_uif:		out	std_logic
			);
end TOP_DESIGN;

architecture Behavioral of TOP_DESIGN is

--******************************************************
-- Components definition
--******************************************************

--------------------------------------------------------
--	PLL 
--------------------------------------------------------	
--COMPONENT PLL_DDR_SYSTEM_CLK
--	PORT(
--		CLKIN1_IN : IN std_logic;    	-- 50MHz        
--		CLKOUT0_OUT : OUT std_logic;	-- 133,333MHz
--		CLKOUT1_OUT : OUT std_logic;	-- 200MHz
--		LOCKED_OUT : OUT std_logic
--		);
--	END COMPONENT;


--+++++++++++++++++++++++++++++++++++++++
-- only for testing without RAM Memory Controller
COMPONENT PLL_DDR_SYSTEM_CLK
	PORT(
		CLKIN1_IN : IN std_logic;        -- 50MHz  
		CLKOUT0_OUT : OUT std_logic;		-- 133,333MHz
		CLKOUT1_OUT : OUT std_logic;		-- 200MHz
		CLKOUT2_OUT : OUT std_logic;		-- 266,667MHz
		LOCKED_OUT : OUT std_logic
		);
	END COMPONENT;

--------------------------------------------------------
--	RAM Modell
--------------------------------------------------------	
	
COMPONENT ddr2_model
	PORT(
		ck : IN std_logic_vector((CLK_WIDTH-1) downto 0);
		ck_n : IN std_logic_vector((CLK_WIDTH-1) downto 0);
		cke : IN std_logic_vector((CKE_WIDTH-1) downto 0);
		cs_n : IN std_logic_vector((CS_WIDTH-1) downto 0);
		ras_n : IN std_logic;
		cas_n : IN std_logic;
		we_n : IN std_logic;
		ba : IN std_logic_vector((BANK_WIDTH-1) downto 0);
		addr : IN std_logic_vector((ROW_WIDTH-1) downto 0);
		odt : IN std_logic_vector((ODT_WIDTH-1) downto 0);    
		dm_rdqs : INOUT std_logic_vector((DM_WIDTH-1) downto 0);
		dq : INOUT std_logic_vector((DQ_WIDTH-1) downto 0);
		dqs : INOUT std_logic_vector((DQS_WIDTH-1) downto 0);
		dqs_n : INOUT std_logic_vector((DQS_WIDTH-1) downto 0);      
		rdqs_n : OUT std_logic_vector((DQS_WIDTH-1) downto 0)
		);
	END COMPONENT;
--+++++++++++++++++++++++++++++++++++++++
--------------------------------------------------------
--	Pixel Adder
--------------------------------------------------------

--COMPONENT PIXEL_ADDER
--	PORT(
--		d_pix_0 : IN std_logic_vector(11 downto 0);
--		d_pix_1 : IN std_logic_vector(11 downto 0);
--		d_pix_2 : IN std_logic_vector(11 downto 0);
--		d_pix_3 : IN std_logic_vector(11 downto 0);
--		r_pix_0 : IN std_logic_vector(11 downto 0);
--		r_pix_1 : IN std_logic_vector(11 downto 0);
--		r_pix_2 : IN std_logic_vector(11 downto 0);
--		r_pix_3 : IN std_logic_vector(11 downto 0);          
--		res_pix_0 : OUT std_logic_vector(11 downto 0);
--		res_pix_1 : OUT std_logic_vector(11 downto 0);
--		res_pix_2 : OUT std_logic_vector(11 downto 0);
--		res_pix_3 : OUT std_logic_vector(11 downto 0)
--		);
--	END COMPONENT;


--------------------------------------------------------
--	DVI FIFO
--------------------------------------------------------

--***********************
-- Pixel Bus definition
--	din = dout
--	din(11:0)	=	pix0(11:0)
-- din(23:12)	=	pix1(11:0)
--	din(35:24)	=	pix2(11:0)
-- din(47:36)	=	pix3(11:0)
-- din(48)		=	DE
-- din(49)		=	HSYNC
-- din(50)		=	VSYNC
-- din(51)		=	CTL1
-- din(52)		=	CTL2
-- din(53)		=	CTL3
--***********************

--COMPONENT FIFO_DVI_SIGNALS
--  PORT (
--    wr_clk : IN STD_LOGIC;
--    wr_rst : IN STD_LOGIC;
--    rd_clk : IN STD_LOGIC;
--    rd_rst : IN STD_LOGIC;
--    din : IN STD_LOGIC_VECTOR(53 DOWNTO 0);
--    wr_en : IN STD_LOGIC;
--    rd_en : IN STD_LOGIC;
--    dout : OUT STD_LOGIC_VECTOR(53 DOWNTO 0);
--    full : OUT STD_LOGIC;
--    empty : OUT STD_LOGIC;
--    valid : OUT STD_LOGIC;
--
--    rd_data_count : OUT STD_LOGIC_VECTOR(9 DOWNTO 0);
--    wr_data_count : OUT STD_LOGIC_VECTOR(9 DOWNTO 0)
--  );
--END COMPONENT;

--------------------------------------------------------
-- one clock pixel delay 
--------------------------------------------------------

--COMPONENT DVI_DATA_DELAY
--	PORT(
--		din : IN std_logic_vector(47 downto 0);
--		pix_st_in : IN std_logic;
--		clk : IN std_logic;          
--		pix_st_out : OUT std_logic;
--		dout : OUT std_logic_vector(47 downto 0)
--		);
--	END COMPONENT;

--------------------------------------------------------
--	adress counter
--------------------------------------------------------
	
	
--COMPONENT ADR_COUNT
--	PORT(
--		reset : IN std_logic;
--		clk : IN std_logic;
--		dvi_de : IN std_logic;
--		dvi_vsync : IN std_logic;
--		data_valid : IN std_logic;
--		bank_adr : IN std_logic_vector(2 downto 0);          
--		wr_enable : OUT std_logic;
--		ram_adress : OUT std_logic_vector(30 downto 0)
--		);
--	END COMPONENT;
	
	
COMPONENT RAM_ADSRESS_COUNT
	PORT(
		reset : IN std_logic;
		clk : IN std_logic;
		count_en : IN std_logic;
		FIFO_full : IN std_logic;
		bank_adr : IN std_logic_vector(2 downto 0);          
		rd_enable : OUT std_logic;
		ram_adress : OUT std_logic_vector(30 downto 0)
		);
	END COMPONENT;
	

--------------------------------------------------------
--	Serial to parallel converter
--------------------------------------------------------

COMPONENT SERIAL_PARALLEL_CONVERTER
	PORT(
		ram_pixel_data_in : IN std_logic_vector(31 downto 0);
		rd_data_valid : IN std_logic;
		reset : IN std_logic;
		clk : IN std_logic;          
		data_valid : OUT std_logic;
		ram_pixel_data_out : OUT std_logic_vector(47 downto 0)
		);
	END COMPONENT;
	
--------------------------------------------------------
--	Pixel row FIFO
--------------------------------------------------------

COMPONENT PIXEL_ROW_FIFO
  PORT (
    clk : IN STD_LOGIC;
    rst : IN STD_LOGIC;
    din : IN STD_LOGIC_VECTOR(47 DOWNTO 0);
    wr_en : IN STD_LOGIC;
    rd_en : IN STD_LOGIC;
    dout : OUT STD_LOGIC_VECTOR(47 DOWNTO 0);
    full : OUT STD_LOGIC;
    empty : OUT STD_LOGIC;
	 valid : OUT STD_LOGIC;
    prog_empty : OUT STD_LOGIC
  );
END COMPONENT;

--------------------------------------------------------
--	DVI Pixel FIFO
--------------------------------------------------------

--COMPONENT DVI_PIXEL_FIFO
--  PORT (
--    clk : IN STD_LOGIC;
--    rst : IN STD_LOGIC;
--    din : IN STD_LOGIC_VECTOR(47 DOWNTO 0);
--    wr_en : IN STD_LOGIC;
--    rd_en : IN STD_LOGIC;
--    dout : OUT STD_LOGIC_VECTOR(47 DOWNTO 0);
--    full : OUT STD_LOGIC;
--    empty : OUT STD_LOGIC
--  );
--END COMPONENT;

--------------------------------------------------------
--	add enable
--------------------------------------------------------

--COMPONENT ENABLE_ADD
--	PORT(
--		RF_emty : IN std_logic;
--		DF_emty : IN std_logic;          
--		rd_en : OUT std_logic
--		);
--END COMPONENT;



--------------------------------------------------------
--	RAM read simulation
--------------------------------------------------------
	
--COMPONENT RAM_READ_COM
--	PORT(
--		rd_enable_in : IN std_logic;
--		rd_adr_in : IN std_logic_vector(30 downto 0);
--		clk_1 : IN std_logic;
--		clk_2 : IN std_logic;
--		reset : IN std_logic;          
--		rd_data_out : OUT std_logic_vector(31 downto 0);
--		rd_data_vali_out : OUT std_logic
--		);
--	END COMPONENT;
	
--------------------------------------------------------
--	DDR Memory Controller 
--------------------------------------------------------

component MEMORY_CONTROLLER_TEST
port (
-- memory signals---------------------------------------
   ddr2_dq               : inout  std_logic_vector((DQ_WIDTH-1) downto 0);
   ddr2_a                : out   std_logic_vector((ROW_WIDTH-1) downto 0);
   ddr2_ba               : out   std_logic_vector((BANK_WIDTH-1) downto 0);
   ddr2_ras_n            : out   std_logic;
   ddr2_cas_n            : out   std_logic;
   ddr2_we_n             : out   std_logic;
   ddr2_cs_n             : out   std_logic_vector((CS_WIDTH-1) downto 0);
   ddr2_odt              : out   std_logic_vector((ODT_WIDTH-1) downto 0);
   ddr2_cke              : out   std_logic_vector((CKE_WIDTH-1) downto 0);
   ddr2_dm               : out   std_logic_vector((DM_WIDTH-1) downto 0);
	ddr2_dqs              : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_dqs_n            : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_ck               : out   std_logic_vector((CLK_WIDTH-1) downto 0);
   ddr2_ck_n             : out   std_logic_vector((CLK_WIDTH-1) downto 0);
-- clocks-------------------------------------------------
	sys_clk               : in    std_logic;													-- Clock for the internal PLL
   idly_clk_200          : in    std_logic;													-- Clock for the idelay controll module (calibrates the delay)
   sys_rst_n             : in    std_logic;													-- DDR2 RAM reset
-- userinterface-------------------------------------------
   phy_init_done         : out   std_logic;													-- init and calibration done
   rst0_tb               : out   std_logic;													-- reset output for user interface
   clk0_tb               : out   std_logic;													-- User clock output
   app_wdf_afull         : out   std_logic;													-- Write FIFO full, 12 data elements less
   app_af_afull          : out   std_logic;													-- Adress FIFO full, 12 addesses less
   rd_data_valid         : out   std_logic;													-- indicat that read data is valid
   app_wdf_wren          : in    std_logic;													-- WE DATA, has to be synchronized to data, mask
   app_af_wren           : in    std_logic;													-- WE Address, has to be synchronized to addr, cmd
   app_af_addr           : in    std_logic_vector(30 downto 0);						-- app_af_addr[BANK_WIDTH+ROW_WIDTH+COL_WIDTH]
   app_af_cmd            : in    std_logic_vector(2 downto 0);							-- b000for write command, b001 for read command
   rd_data_fifo_out      : out   std_logic_vector((APPDATA_WIDTH-1) downto 0);	-- contains the read data
   app_wdf_data          : in    std_logic_vector((APPDATA_WIDTH-1) downto 0);	-- contain the rise and fall data [Fall+Rise]
   app_wdf_mask_data     : in    std_logic_vector((APPDATA_WIDTH/8-1) downto 0)	-- contain of the mask data [Fall+Rise] 
);
end component;


--******************************************************
-- End Components definition
--******************************************************

--******************************************************
-- Signal definition
--******************************************************

-- Clocksignals-----------------------------------------
signal clk_133: 			std_logic;
signal clk_200:			std_logic;
signal clk_266:			std_logic;
signal PLL_locked:		std_logic;

-- RAM Bus Signal --------------------------------------
signal t_ram_wr_pix0:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix1:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix2:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix3:	STD_LOGIC_VECTOR(11 downto 0);

-- DVI Bus Signal --------------------------------------
signal t_dvi_bus_out:	STD_LOGIC_VECTOR(53 downto 0);

-- DVI FIFO Signal -------------------------------------
signal t_f_dvi_empty:		std_logic;
signal t_f_dvi_valid:		std_logic;
signal t_dvi_bus_delay:		STD_LOGIC_VECTOR(47 downto 0);

-- adress counter Signal -------------------------------
signal t_ram_rd_en :  std_logic;
signal t_ram_rd_adr:		 STD_LOGIC_VECTOR(30 downto 0);
signal t_ram_wr_adr:		 STD_LOGIC_VECTOR(30 downto 0);
signal t_AC_we:	 std_logic;

-- RAM read sim Signal ---------------------------------
signal t_ram_data:	STD_LOGIC_VECTOR(31 downto 0);
signal t_ram_data_valid: std_logic;

-- Serial / Parallel Converter Signal ---------------------------------
signal t_SP_RP_out: STD_LOGIC_VECTOR(47 downto 0);
signal t_SP_RP_valid:		  std_logic;

-- RAM Row FIFO ---------------------------------
signal t_RR_FIFO_full:	std_logic;
signal t_RR_FIFO_empty:	std_logic;
signal t_RR_FIFO_pemty:	std_logic;
signal t_RR_FIFO_valid:	std_logic;
signal t_RR_FIFO_rd_en:	std_logic := '0';

-- Pixel Delay Signal ---------------------------------
signal t_pix_st:	std_logic;

-- DVI Pixel FIFO Signal ---------------------------------
signal t_DVI_PF_dout:	STD_LOGIC_VECTOR(47 downto 0);
signal t_DVI_PF_emty:	std_logic;
signal t_DVI_PF_full:	std_logic;
signal t_DVI_PF_valid:	std_logic;
signal t_DVI_PF_pemty:	std_logic;


-- Add enable Signal -------------------------------------
signal t_add_en:		std_logic;


signal t_dvi_pixel0_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_dvi_pixel1_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_dvi_pixel2_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_dvi_pixel3_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_pixel0_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_pixel1_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_pixel2_data_out: STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_pixel3_data_out: STD_LOGIC_VECTOR(11 downto 0);



-- Test Signale --------------------------------------------
signal t_TEST: std_logic;

signal t_ddr2_dq:       std_logic_vector((DQ_WIDTH-1) downto 0);
signal t_ddr2_a:   	 	std_logic_vector((ROW_WIDTH-1) downto 0);
signal t_ddr2_ba:    	std_logic_vector((BANK_WIDTH-1) downto 0);
signal t_ddr2_ras_n:    std_logic;
signal t_ddr2_cas_n:    std_logic;
signal t_ddr2_we_n:    	std_logic;
signal t_ddr2_cs_n:    	std_logic_vector((CS_WIDTH-1) downto 0);
signal t_ddr2_odt:   	std_logic_vector((ODT_WIDTH-1) downto 0);
signal t_ddr2_cke:    	std_logic_vector((CKE_WIDTH-1) downto 0);
signal t_ddr2_dm:    	std_logic_vector((DM_WIDTH-1) downto 0);
signal t_ddr2_dqs:   	std_logic_vector((DQS_WIDTH-1) downto 0);
signal t_ddr2_dqs_n:   	std_logic_vector((DQS_WIDTH-1) downto 0);
signal t_ddr2_ck:    	std_logic_vector((CLK_WIDTH-1) downto 0);
signal t_ddr2_ck_n:    	std_logic_vector((CLK_WIDTH-1) downto 0);

--******************************************************
-- End Signal definition
--******************************************************

begin

-- PLL --------------------------------------------------

Inst_PLL_DDR_SYSTEM_CLK: PLL_DDR_SYSTEM_CLK PORT MAP(
		CLKIN1_IN => clk_ext,
		CLKOUT0_OUT => clk_133,
		CLKOUT1_OUT => clk_200,
		CLKOUT2_OUT => clk_266,
		LOCKED_OUT => PLL_locked
	);


-- read adress counter (read data) -----------------------	

Inst_RAM_ADSRESS_COUNT: RAM_ADSRESS_COUNT PORT MAP(
		reset => ext_reset,
		clk => clk_133,
		count_en => '1',--t_dvi_bus_out(48),
		FIFO_full => '0',
		bank_adr => "000",
		rd_enable => t_ram_rd_en,
		ram_adress => t_ram_rd_adr
	);
	

-- Serial to parallel converter --------------------------

Inst_SERIAL_PARALLEL_CONVERTER: SERIAL_PARALLEL_CONVERTER PORT MAP(
		ram_pixel_data_in => t_ram_data,
		rd_data_valid => t_ram_data_valid,
		reset => ext_reset,
		clk => clk_133,
		data_valid => t_SP_RP_valid,
		ram_pixel_data_out => t_SP_RP_out
	);
	
	
-- Pixel Row FIFO -----------------------------------------

Inst_PIXEL_ROW_FIFO : PIXEL_ROW_FIFO PORT MAP (
    clk => clk_133,
    rst => ext_reset,
    din => t_SP_RP_out,
    wr_en => t_SP_RP_valid,
    rd_en => t_add_en,
    dout => test_dout,
    full => t_RR_FIFO_full,
    empty => t_RR_FIFO_empty,
	 valid => t_RR_FIFO_valid,
    prog_empty => t_RR_FIFO_pemty
  );


	

-- Memory Conroller

u_MEMORY_CONTROLLER_TEST : MEMORY_CONTROLLER_TEST
generic map (
     BANK_WIDTH => BANK_WIDTH,
     CKE_WIDTH => CKE_WIDTH,
     CLK_WIDTH => CLK_WIDTH,
     COL_WIDTH => COL_WIDTH,
     CS_NUM => CS_NUM,
     CS_WIDTH => CS_WIDTH,
     CS_BITS => CS_BITS,
     DM_WIDTH => DM_WIDTH,
     DQ_WIDTH => DQ_WIDTH,
     DQ_PER_DQS => DQ_PER_DQS,
     DQS_WIDTH => DQS_WIDTH,
     DQ_BITS => DQ_BITS,
     DQS_BITS => DQS_BITS,
     ODT_WIDTH => ODT_WIDTH,
     ROW_WIDTH => ROW_WIDTH,
     ADDITIVE_LAT => ADDITIVE_LAT,
     BURST_LEN => BURST_LEN,
     BURST_TYPE => BURST_TYPE,
     CAS_LAT => CAS_LAT,
     ECC_ENABLE => ECC_ENABLE,
     APPDATA_WIDTH => APPDATA_WIDTH,
     MULTI_BANK_EN => MULTI_BANK_EN,
     TWO_T_TIME_EN => TWO_T_TIME_EN,
     ODT_TYPE => ODT_TYPE,
     REDUCE_DRV => REDUCE_DRV,
     REG_ENABLE => REG_ENABLE,
     TREFI_NS => TREFI_NS,
     TRAS => TRAS,
     TRCD => TRCD,
     TRFC => TRFC,
     TRP => TRP,
     TRTP => TRTP,
     TWR => TWR,
     TWTR => TWTR,
     HIGH_PERFORMANCE_MODE => HIGH_PERFORMANCE_MODE,
     SIM_ONLY => SIM_ONLY,
     DEBUG_EN => DEBUG_EN,
     CLK_PERIOD => CLK_PERIOD,
     DLL_FREQ_MODE => DLL_FREQ_MODE,
     CLK_TYPE => CLK_TYPE,
     NOCLK200 => NOCLK200,
     RST_ACT_LOW => RST_ACT_LOW
)
port map (
-- memory signals---------------------------------------
   ddr2_dq                    => ddr2_dq,
   ddr2_a                     => ddr2_a,
   ddr2_ba                    => ddr2_ba,
   ddr2_ras_n                 => ddr2_ras_n,
   ddr2_cas_n                 => ddr2_cas_n,
   ddr2_we_n                  => ddr2_we_n,
   ddr2_cs_n                  => ddr2_cs_n,
   ddr2_odt                   => ddr2_odt,
   ddr2_cke                   => ddr2_cke,
   ddr2_dm                    => ddr2_dm,
	ddr2_dqs                   => ddr2_dqs,
   ddr2_dqs_n                 => ddr2_dqs_n,
   ddr2_ck                    => ddr2_ck,
   ddr2_ck_n                  => ddr2_ck_n,
-- clocks-------------------------------------------------
   sys_clk                    => clk_133,
   idly_clk_200               => clk_200,
   sys_rst_n                  => ddr2_reset,
-- userinterface-------------------------------------------
   phy_init_done              => test_ddr_init_done,	-- 
   rst0_tb                    => '0', -- 
   clk0_tb                    => test_ddr_clk_uif,   -- 
   app_wdf_afull              => test_ddr_wdf_full,	-- write data FIFO full
   app_af_afull               => test_ddr_af_full,		-- adress FIFO full
   rd_data_valid              => t_ram_data_valid, 	--
   app_wdf_wren               => '0',  					--  WE -> Daten in FIFO schreiben
   app_af_wren                => t_ram_rd_en,			--  WE -> Addresse in FIFO schreiben
   app_af_addr                => t_ram_rd_adr,			--  Read Addresse 
   app_af_cmd                 => "001",					--  command 
   rd_data_fifo_out           => t_ram_data, 			-- NC Read Daten
   app_wdf_data               => (others => '0'),		--app_wdf_data,		-- NC Wrie Daten
   app_wdf_mask_data          => (others => '0')		--app_wdf_mask_data	-- NC Write Data Mask
);

Inst_ddr2_model: ddr2_model PORT MAP(

		ck => t_ddr2_ck,
		ck_n => t_ddr2_ck_n,
		cke => t_ddr2_cke,
		cs_n => t_ddr2_cs_n,
		ras_n => t_ddr2_ras_n,
		cas_n => t_ddr2_cas_n,
		we_n => t_ddr2_we_n,
		dm_rdqs => t_ddr2_dm,
		ba => t_ddr2_ba,
		addr => t_ddr2_a,
		dq => t_ddr2_dq,
		dqs => t_ddr2_dqs,
		dqs_n => t_ddr2_dqs_n,
		rdqs_n => test_rdqs_n,
		odt => t_ddr2_odt
	);
-- RAM read simulation  ----------------------------------------
	
--Inst_RAM_READ_COM: RAM_READ_COM PORT MAP(
--		rd_enable_in => t_ram_rd_en,
--		rd_adr_in => t_ram_rd_adr,
--		clk_1 => clk_133,
--		clk_2 => clk_266,
--		reset => ext_reset,
--		rd_data_out => t_ram_data,
--		rd_data_vali_out => t_ram_data_valid
--	);


end Behavioral;
