------------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    13:57:02 06/18/2013 
-- Design Name: 
-- Module Name:    TOP_DESIGN - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

library APS_EMO_LIBRARY;
use APS_EMO_LIBRARY.COMPONENTS_PACKAGE.all;
--use work.COMPONENTS_PACKAGE.all;
--use work.DDR_PACKAGE.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity TOP_DESIGN_01 is
	port(	
			clk_ext:			in		STD_LOGIC;
			ext_reset:			in		std_logic;
			
-- RAM Row FIFO Testsignale ---------------------------------------
			test_dout:				out	STD_LOGIC_VECTOR(47 downto 0);
			test_dvi_full:			out	std_logic;
			test_fifo_dw_count:	out	STD_LOGIC_VECTOR(9 downto 0);
			test_fifo_dr_count:	out	STD_LOGIC_VECTOR(9 downto 0);
			test_rd_en_DVI_FIFO: in		std_logic;
			test_rd_en_RP_FIFO:	in		std_logic;
			test_dvi_wr_en:		in		std_logic;
-- DDR2 Testsignale------------------------------------
			test_ddr_wdf_full:		out	std_logic;
			test_ddr_af_full:			out	std_logic;
			test_ddr_init_done:		out	std_logic;
			test_ddr_reset_uif:		out	std_logic;
			test_rdqs_n:				out	std_logic_vector(1 downto 0);
			test_rst0_tb:				out	std_logic;
			test_ddr_clk_uif:			out	std_logic
			);
end TOP_DESIGN_01;

architecture Behavioral of TOP_DESIGN_01 is


--------------------------------------------------------
--	RAM Modell
--------------------------------------------------------	

COMPONENT ddr2_model
	PORT(
		ck : IN std_logic;
		ck_n : IN std_logic;
		cke : IN std_logic;
		cs_n : IN std_logic;
		ras_n : IN std_logic;
		cas_n : IN std_logic;
		we_n : IN std_logic;
		ba : IN std_logic_vector((BANK_WIDTH-1) downto 0);
		addr : IN std_logic_vector(12 downto 0);
		odt : IN std_logic;    
		dm_rdqs : INOUT std_logic_vector((DM_WIDTH-1) downto 0);
		dq : INOUT std_logic_vector((DQ_WIDTH-1) downto 0);
		dqs : INOUT std_logic_vector((DQS_WIDTH-1) downto 0);
		dqs_n : INOUT std_logic_vector((DQS_WIDTH-1) downto 0);      
		rdqs_n : OUT std_logic_vector((DQS_WIDTH-1) downto 0)
		);
	END COMPONENT;
--+++++++++++++++++++++++++++++++++++++++

--******************************************************
-- Signal definition
--******************************************************

-- Clocksignals-----------------------------------------
signal clk_133: 			std_logic;
signal clk_200:			std_logic;
signal clk_266:			std_logic;
signal PLL_locked:		std_logic;

-- RAM Bus Signal --------------------------------------
signal t_ram_wr_pix0:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix1:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix2:	STD_LOGIC_VECTOR(11 downto 0);
signal t_ram_wr_pix3:	STD_LOGIC_VECTOR(11 downto 0);

-- DVI Bus Signal --------------------------------------
signal t_dvi_bus_out:	STD_LOGIC_VECTOR(53 downto 0);

-- DVI FIFO Signal -------------------------------------
signal t_f_dvi_empty:		std_logic;
signal t_f_dvi_valid:		std_logic;
signal t_dvi_bus_delay:		STD_LOGIC_VECTOR(47 downto 0);

-- adress counter Signal -------------------------------
signal t_ram_rd_en :  std_logic;
signal t_ram_rd_adr:		 STD_LOGIC_VECTOR(30 downto 0);
signal t_ram_wr_adr:		 STD_LOGIC_VECTOR(30 downto 0);
signal t_AC_we:	 std_logic;

-- RAM read sim Signal ---------------------------------
signal t_ram_data:	STD_LOGIC_VECTOR(31 downto 0);
signal t_ram_data_valid: std_logic;

-- Serial / Parallel Converter Signal ---------------------------------
signal t_SP_RP_out: STD_LOGIC_VECTOR(47 downto 0);
signal t_SP_RP_valid:		  std_logic;

-- RAM Row FIFO ---------------------------------
signal t_RR_FIFO_full:	std_logic;
signal t_RR_FIFO_empty:	std_logic;
signal t_RR_FIFO_pemty:	std_logic;
signal t_RR_FIFO_valid:	std_logic;
signal t_RR_FIFO_rd_en:	std_logic := '0';



-- Test Signale --------------------------------------------
signal t_TEST: std_logic;
	signal t_ddr2_dq               :    std_logic_vector((DQ_WIDTH-1) downto 0);
   signal t_ddr2_a                :     std_logic_vector((ROW_WIDTH-1) downto 0);
   signal t_ddr2_ba               :    std_logic_vector((BANK_WIDTH-1) downto 0);
   signal t_ddr2_ras_n            :    std_logic;
   signal t_ddr2_cas_n            :    std_logic;
   signal t_ddr2_we_n             :    std_logic;
   signal t_ddr2_cs_n             :    std_logic_vector((CS_WIDTH-1) downto 0);
   signal t_ddr2_odt              :    std_logic_vector((ODT_WIDTH-1) downto 0);
   signal t_ddr2_cke              :   std_logic_vector((CKE_WIDTH-1) downto 0);
   signal t_ddr2_dm               :   std_logic_vector((DM_WIDTH-1) downto 0);
	signal t_ddr2_dqs              :    std_logic_vector((DQS_WIDTH-1) downto 0);
   signal t_ddr2_dqs_n            :    std_logic_vector((DQS_WIDTH-1) downto 0);
   signal t_ddr2_ck               :    std_logic_vector((CLK_WIDTH-1) downto 0);
   signal t_ddr2_ck_n             :    std_logic_vector((CLK_WIDTH-1) downto 0);


--******************************************************
-- End Signal definition
--******************************************************

begin

-- PLL --------------------------------------------------

Inst_PLL_DDR_SYSTEM_CLK: PLL_DDR_SYSTEM_CLK PORT MAP(
		CLKIN1_IN => clk_ext,
		RST_IN => '0',
		CLKOUT0_OUT => clk_133,
		CLKOUT1_OUT => clk_200,
		CLKOUT2_OUT => clk_266,
		LOCKED_OUT => PLL_locked
	);


-- read adress counter (read data) -----------------------	

Inst_RAM_ADSRESS_COUNT: RAM_ADSRESS_COUNT PORT MAP(
		reset => ext_reset,
		clk => clk_133,
		count_en => '1',--t_dvi_bus_out(48),
		FIFO_full => '0',
		bank_adr => "000",
		rd_enable => t_ram_rd_en,
		ram_adress => t_ram_rd_adr
	);
	

-- Serial to parallel converter --------------------------

Inst_SERIAL_PARALLEL_CONVERTER: SERIAL_PARALLEL_CONVERTER PORT MAP(
		ram_pixel_data_in => t_ram_data,
		rd_data_valid => t_ram_data_valid,
		reset => ext_reset,
		clk => clk_133,
		data_valid => t_SP_RP_valid,
		ram_pixel_data_out => t_SP_RP_out
	);
	
	
-- Pixel Row FIFO -----------------------------------------

Inst_PIXEL_ROW_FIFO : PIXEL_ROW_FIFO PORT MAP (
    clk => clk_133,
    rst => ext_reset,
    din => t_SP_RP_out,
    wr_en => t_SP_RP_valid,
    rd_en => '1',
    dout => test_dout,
    full => t_RR_FIFO_full,
    empty => t_RR_FIFO_empty,
	 valid => t_RR_FIFO_valid,
    prog_empty => t_RR_FIFO_pemty
  );


	

-- Memory Conroller

u_MEMORY_CONTROLLER_TEST : MEMORY_CONTROLLER_TEST
generic map (
     BANK_WIDTH => BANK_WIDTH,
     CKE_WIDTH => CKE_WIDTH,
     CLK_WIDTH => CLK_WIDTH,
     COL_WIDTH => COL_WIDTH,
     CS_NUM => CS_NUM,
     CS_WIDTH => CS_WIDTH,
     CS_BITS => CS_BITS,
     DM_WIDTH => DM_WIDTH,
     DQ_WIDTH => DQ_WIDTH,
     DQ_PER_DQS => DQ_PER_DQS,
     DQS_WIDTH => DQS_WIDTH,
     DQ_BITS => DQ_BITS,
     DQS_BITS => DQS_BITS,
     ODT_WIDTH => ODT_WIDTH,
     ROW_WIDTH => ROW_WIDTH,
     ADDITIVE_LAT => ADDITIVE_LAT,
     BURST_LEN => BURST_LEN,
     BURST_TYPE => BURST_TYPE,
     CAS_LAT => CAS_LAT,
     ECC_ENABLE => ECC_ENABLE,
     APPDATA_WIDTH => APPDATA_WIDTH,
     MULTI_BANK_EN => MULTI_BANK_EN,
     TWO_T_TIME_EN => TWO_T_TIME_EN,
     ODT_TYPE => ODT_TYPE,
     REDUCE_DRV => REDUCE_DRV,
     REG_ENABLE => REG_ENABLE,
     TREFI_NS => TREFI_NS,
     TRAS => TRAS,
     TRCD => TRCD,
     TRFC => TRFC,
     TRP => TRP,
     TRTP => TRTP,
     TWR => TWR,
     TWTR => TWTR,
     HIGH_PERFORMANCE_MODE => HIGH_PERFORMANCE_MODE,
     SIM_ONLY => SIM_ONLY,
     DEBUG_EN => DEBUG_EN,
     CLK_PERIOD => CLK_PERIOD,
     DLL_FREQ_MODE => DLL_FREQ_MODE,
     CLK_TYPE => CLK_TYPE,
     NOCLK200 => NOCLK200,
     RST_ACT_LOW => RST_ACT_LOW
)
port map (
-- memory signals---------------------------------------
   ddr2_dq                    => t_ddr2_dq,
   ddr2_a                     => t_ddr2_a,
   ddr2_ba                    => t_ddr2_ba,
   ddr2_ras_n                 => t_ddr2_ras_n,
   ddr2_cas_n                 => t_ddr2_cas_n,
   ddr2_we_n                  => t_ddr2_we_n,
   ddr2_cs_n                  => t_ddr2_cs_n,
   ddr2_odt                   => t_ddr2_odt,
   ddr2_cke                   => t_ddr2_cke,
   ddr2_dm                    => t_ddr2_dm,
	ddr2_dqs                   => t_ddr2_dqs,
   ddr2_dqs_n                 => t_ddr2_dqs_n,
   ddr2_ck                    => t_ddr2_ck,
   ddr2_ck_n                  => t_ddr2_ck_n,
-- clocks-------------------------------------------------
   sys_clk                    => clk_133,
   idly_clk_200               => clk_200,
   sys_rst_n                  => ext_reset,
-- userinterface-------------------------------------------
   phy_init_done              => test_ddr_init_done,	-- 
   rst0_tb                    => test_rst0_tb, -- 
   clk0_tb                    => test_ddr_clk_uif,   -- 
   app_wdf_afull              => test_ddr_wdf_full,	-- write data FIFO full
   app_af_afull               => test_ddr_af_full,		-- adress FIFO full
   rd_data_valid              => t_ram_data_valid, 	--
   app_wdf_wren               => '0',  					--  WE -> Daten in FIFO schreiben
   app_af_wren                => t_ram_rd_en,			--  WE -> Addresse in FIFO schreiben
   app_af_addr                => t_ram_rd_adr,			--  Read Addresse 
   app_af_cmd                 => "001",					--  command 
   rd_data_fifo_out           => t_ram_data, 			-- NC Read Daten
   app_wdf_data               => (others => '0'),		--app_wdf_data,		-- NC Wrie Daten
   app_wdf_mask_data          => (others => '0')		--app_wdf_mask_data	-- NC Write Data Mask
);

Inst_ddr2_model: ddr2_model PORT MAP(

		ck => t_ddr2_ck(0),
		ck_n => t_ddr2_ck_n(0),
		cke => t_ddr2_cke(0),
		cs_n => t_ddr2_cs_n(0),
		ras_n => t_ddr2_ras_n,
		cas_n => t_ddr2_cas_n,
		we_n => t_ddr2_we_n,
		dm_rdqs => t_ddr2_dm,
		ba => t_ddr2_ba,
		addr => (others => '0'),--t_ddr2_a,
		dq => t_ddr2_dq,
		dqs => t_ddr2_dqs,
		dqs_n => t_ddr2_dqs_n,
		rdqs_n => test_rdqs_n,
		odt => t_ddr2_odt(0)
	);


end Behavioral;


