----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    13:21:52 07/04/2013 
-- Design Name: 
-- Module Name:    TOP_DESIGN_OMC - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
--use work.DDR_PACKAGE.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity TOP_DESIGN_OMC is
	port(
			clk_ext:			in		STD_LOGIC;
			ext_reset:			in		std_logic
			
	);
end TOP_DESIGN_OMC;

architecture Behavioral of TOP_DESIGN_OMC is

	COMPONENT PLL_DDR_SYSTEM_CLK
	PORT(
		CLKIN1_IN : IN std_logic;        -- 50MHz  
		CLKOUT0_OUT : OUT std_logic;		-- 133,333MHz
		CLKOUT1_OUT : OUT std_logic;		-- 200MHz
		CLKOUT2_OUT : OUT std_logic;		-- 266,667MHz
		LOCKED_OUT : OUT std_logic
		);
	END COMPONENT;
	
	COMPONENT ddr2_model
	generic(
     BANK_WIDTH               : integer := 3;    
                              -- # of memory bank addr bits.
     CKE_WIDTH                : integer := 1;    
                              -- # of memory clock enable outputs.
     CLK_WIDTH                : integer := 1;    
                              -- # of clock outputs.
     COL_WIDTH                : integer := 10;    
                              -- # of memory column bits.
     CS_NUM                   : integer := 1;    
                              -- # of separate memory chip selects.
     CS_WIDTH                 : integer := 1;    
                              -- # of total memory chip selects.
     CS_BITS                  : integer := 0;    
                              -- set to log2(CS_NUM) (rounded up).
     DM_WIDTH                 : integer := 2;    
                              -- # of data mask bits.
     DQ_WIDTH                 : integer := 16;    
                              -- # of data width.
     DQ_PER_DQS               : integer := 8;    
                              -- # of DQ data bits per strobe.
     DQS_WIDTH                : integer := 2;    
                              -- # of DQS strobes.
     DQ_BITS                  : integer := 4;    
                              -- set to log2(DQS_WIDTH*DQ_PER_DQS).
     DQS_BITS                 : integer := 1;    
                              -- set to log2(DQS_WIDTH).
     ODT_WIDTH                : integer := 1;    
                              -- # of memory on-die term enables.
     ROW_WIDTH                : integer := 13;    
                              -- # of memory row and # of addr bits.
     ADDITIVE_LAT             : integer := 0;    
                              -- additive write latency.
     BURST_LEN                : integer := 4;    
                              -- burst length (in double words).
     BURST_TYPE               : integer := 0;    
                              -- burst type (=0 seq; =1 interleaved).
     CAS_LAT                  : integer := 4;    
                              -- CAS latency.
     ECC_ENABLE               : integer := 0;    
                              -- enable ECC (=1 enable).
     APPDATA_WIDTH            : integer := 32;    
                              -- # of usr read/write data bus bits.
     MULTI_BANK_EN            : integer := 1;    
                              -- Keeps multiple banks open. (= 1 enable).
     TWO_T_TIME_EN            : integer := 0;    
                              -- 2t timing for unbuffered dimms.
     ODT_TYPE                 : integer := 3;    
                              -- ODT (=0(none),=1(75),=2(150),=3(50)).
     REDUCE_DRV               : integer := 1;    
                              -- reduced strength mem I/O (=1 yes).
     REG_ENABLE               : integer := 0;    
                              -- registered addr/ctrl (=1 yes).
     TREFI_NS                 : integer := 7800;    
                              -- auto refresh interval (ns).
     TRAS                     : integer := 40000;    
                              -- active->precharge delay.
     TRCD                     : integer := 15000;    
                              -- active->read/write delay.
     TRFC                     : integer := 127500;    
                              -- refresh->refresh, refresh->active delay.
     TRP                      : integer := 15000;    
                              -- precharge->command delay.
     TRTP                     : integer := 7500;    
                              -- read->precharge delay.
     TWR                      : integer := 15000;    
                              -- used to determine write->precharge.
     TWTR                     : integer := 7500;    
                              -- write->read delay.
     HIGH_PERFORMANCE_MODE    : boolean := TRUE;    
                              -- # = TRUE, the IODELAY performance mode is set
                              -- to high.
                              -- # = FALSE, the IODELAY performance mode is set
                              -- to low.
     SIM_ONLY                 : integer := 0;    
                              -- = 1 to skip SDRAM power up delay.
     DEBUG_EN                 : integer := 0;    
                              -- Enable debug signals/controls.
                              -- When this parameter is changed from 0 to 1,
                              -- make sure to uncomment the coregen commands
                              -- in ise_flow.bat or create_ise.bat files in
                              -- par folder.
     CLK_PERIOD               : integer := 7500;    
                              -- Core/Memory clock period (in ps).
     DLL_FREQ_MODE            : string := "HIGH";    
                              -- DCM Frequency range.
     CLK_TYPE                 : string := "SINGLE_ENDED";    
                              -- # = "DIFFERENTIAL " ->; Differential input clocks ,
                              -- # = "SINGLE_ENDED" -> Single ended input clocks.
     NOCLK200                 : boolean := FALSE;    
                              -- clk200 enable and disable
     RST_ACT_LOW              : integer := 1     
                              -- =1 for active low reset, =0 for active high.
);
	PORT(
		ck : 			IN 	std_logic_vector((CLK_WIDTH-1) downto 0);
		ck_n : 		IN 	std_logic_vector((CLK_WIDTH-1) downto 0);
		cke : 		IN  	std_logic_vector((CKE_WIDTH-1) downto 0);
		cs_n : 		IN 	std_logic_vector((CS_WIDTH-1) downto 0);
		ras_n : 		IN 	std_logic;
		cas_n : 		IN 	std_logic;
		we_n : 		IN 	std_logic;
		ba : 			IN 	std_logic_vector((BANK_WIDTH-1) downto 0);
		addr : 		IN 	std_logic_vector((ROW_WIDTH-1) downto 0);
		odt : 		IN  	std_logic_vector((ODT_WIDTH-1) downto 0);    
		dm_rdqs : 	OUT 	std_logic_vector((DM_WIDTH-1) downto 0);
		dq : 			INOUT std_logic_vector((DQ_WIDTH-1) downto 0);
		dqs :			INOUT std_logic_vector((DQS_WIDTH-1) downto 0);
		dqs_n : 		INOUT std_logic_vector((DQS_WIDTH-1) downto 0);      
		rdqs_n : 	OUT 	std_logic_vector((DQS_WIDTH-1) downto 0)
		);
	END COMPONENT;
	
	component MEMORY_CONTROLLER_TEST
generic(
     BANK_WIDTH               : integer := 3;    
                              -- # of memory bank addr bits.
     CKE_WIDTH                : integer := 1;    
                              -- # of memory clock enable outputs.
     CLK_WIDTH                : integer := 1;    
                              -- # of clock outputs.
     COL_WIDTH                : integer := 10;    
                              -- # of memory column bits.
     CS_NUM                   : integer := 1;    
                              -- # of separate memory chip selects.
     CS_WIDTH                 : integer := 1;    
                              -- # of total memory chip selects.
     CS_BITS                  : integer := 0;    
                              -- set to log2(CS_NUM) (rounded up).
     DM_WIDTH                 : integer := 2;    
                              -- # of data mask bits.
     DQ_WIDTH                 : integer := 16;    
                              -- # of data width.
     DQ_PER_DQS               : integer := 8;    
                              -- # of DQ data bits per strobe.
     DQS_WIDTH                : integer := 2;    
                              -- # of DQS strobes.
     DQ_BITS                  : integer := 4;    
                              -- set to log2(DQS_WIDTH*DQ_PER_DQS).
     DQS_BITS                 : integer := 1;    
                              -- set to log2(DQS_WIDTH).
     ODT_WIDTH                : integer := 1;    
                              -- # of memory on-die term enables.
     ROW_WIDTH                : integer := 13;    
                              -- # of memory row and # of addr bits.
     ADDITIVE_LAT             : integer := 0;    
                              -- additive write latency.
     BURST_LEN                : integer := 4;    
                              -- burst length (in double words).
     BURST_TYPE               : integer := 0;    
                              -- burst type (=0 seq; =1 interleaved).
     CAS_LAT                  : integer := 4;    
                              -- CAS latency.
     ECC_ENABLE               : integer := 0;    
                              -- enable ECC (=1 enable).
     APPDATA_WIDTH            : integer := 32;    
                              -- # of usr read/write data bus bits.
     MULTI_BANK_EN            : integer := 1;    
                              -- Keeps multiple banks open. (= 1 enable).
     TWO_T_TIME_EN            : integer := 0;    
                              -- 2t timing for unbuffered dimms.
     ODT_TYPE                 : integer := 3;    
                              -- ODT (=0(none),=1(75),=2(150),=3(50)).
     REDUCE_DRV               : integer := 1;    
                              -- reduced strength mem I/O (=1 yes).
     REG_ENABLE               : integer := 0;    
                              -- registered addr/ctrl (=1 yes).
     TREFI_NS                 : integer := 7800;    
                              -- auto refresh interval (ns).
     TRAS                     : integer := 40000;    
                              -- active->precharge delay.
     TRCD                     : integer := 15000;    
                              -- active->read/write delay.
     TRFC                     : integer := 127500;    
                              -- refresh->refresh, refresh->active delay.
     TRP                      : integer := 15000;    
                              -- precharge->command delay.
     TRTP                     : integer := 7500;    
                              -- read->precharge delay.
     TWR                      : integer := 15000;    
                              -- used to determine write->precharge.
     TWTR                     : integer := 7500;    
                              -- write->read delay.
     HIGH_PERFORMANCE_MODE    : boolean := TRUE;    
                              -- # = TRUE, the IODELAY performance mode is set
                              -- to high.
                              -- # = FALSE, the IODELAY performance mode is set
                              -- to low.
     SIM_ONLY                 : integer := 0;    
                              -- = 1 to skip SDRAM power up delay.
     DEBUG_EN                 : integer := 0;    
                              -- Enable debug signals/controls.
                              -- When this parameter is changed from 0 to 1,
                              -- make sure to uncomment the coregen commands
                              -- in ise_flow.bat or create_ise.bat files in
                              -- par folder.
     CLK_PERIOD               : integer := 7500;    
                              -- Core/Memory clock period (in ps).
     DLL_FREQ_MODE            : string := "HIGH";    
                              -- DCM Frequency range.
     CLK_TYPE                 : string := "SINGLE_ENDED";    
                              -- # = "DIFFERENTIAL " ->; Differential input clocks ,
                              -- # = "SINGLE_ENDED" -> Single ended input clocks.
     NOCLK200                 : boolean := FALSE;    
                              -- clk200 enable and disable
     RST_ACT_LOW              : integer := 1     
                              -- =1 for active low reset, =0 for active high.
);
port (
-- memory signals---------------------------------------
   ddr2_dq               : inout  std_logic_vector((DQ_WIDTH-1) downto 0);
   ddr2_a                : out   std_logic_vector((ROW_WIDTH-1) downto 0);
   ddr2_ba               : out   std_logic_vector((BANK_WIDTH-1) downto 0);
   ddr2_ras_n            : out   std_logic;
   ddr2_cas_n            : out   std_logic;
   ddr2_we_n             : out   std_logic;
   ddr2_cs_n             : out   std_logic_vector((CS_WIDTH-1) downto 0);
   ddr2_odt              : out   std_logic_vector((ODT_WIDTH-1) downto 0);
   ddr2_cke              : out   std_logic_vector((CKE_WIDTH-1) downto 0);
   ddr2_dm               : out   std_logic_vector((DM_WIDTH-1) downto 0);
	ddr2_dqs              : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_dqs_n            : inout  std_logic_vector((DQS_WIDTH-1) downto 0);
   ddr2_ck               : out   std_logic_vector((CLK_WIDTH-1) downto 0);
   ddr2_ck_n             : out   std_logic_vector((CLK_WIDTH-1) downto 0);
-- clocks-------------------------------------------------
	sys_clk               : in    std_logic;													-- Clock for the internal PLL
   idly_clk_200          : in    std_logic;													-- Clock for the idelay controll module (calibrates the delay)
   sys_rst_n             : in    std_logic;													-- DDR2 RAM reset
-- userinterface-------------------------------------------
   phy_init_done         : out   std_logic;													-- init and calibration done
   rst0_tb               : out   std_logic;													-- reset output for user interface
   clk0_tb               : out   std_logic;													-- User clock output
   app_wdf_afull         : out   std_logic;													-- Write FIFO full, 12 data elements less
   app_af_afull          : out   std_logic;													-- Adress FIFO full, 12 addesses less
   rd_data_valid         : out   std_logic;													-- indicat that read data is valid
   app_wdf_wren          : in    std_logic;													-- WE DATA, has to be synchronized to data, mask
   app_af_wren           : in    std_logic;													-- WE Address, has to be synchronized to addr, cmd
   app_af_addr           : in    std_logic_vector(30 downto 0);						-- app_af_addr[BANK_WIDTH+ROW_WIDTH+COL_WIDTH]
   app_af_cmd            : in    std_logic_vector(2 downto 0);							-- b000for write command, b001 for read command
   rd_data_fifo_out      : out   std_logic_vector((APPDATA_WIDTH-1) downto 0);	-- contains the read data
   app_wdf_data          : in    std_logic_vector((APPDATA_WIDTH-1) downto 0);	-- contain the rise and fall data [Fall+Rise]
   app_wdf_mask_data     : in    std_logic_vector((APPDATA_WIDTH/8-1) downto 0)	-- contain of the mask data [Fall+Rise] 
);
end component;

-- Clocksignals-----------------------------------------
signal clk_133: 			std_logic;
signal clk_200:			std_logic;
signal clk_266:			std_logic;
signal PLL_locked:		std_logic;

-- Test ------------------------------------------------

signal t_ddr2_dq:       std_logic_vector((DQ_WIDTH-1) downto 0);
signal t_ddr2_a:   	 	std_logic_vector((ROW_WIDTH-1) downto 0);
signal t_ddr2_ba:    	std_logic_vector((BANK_WIDTH-1) downto 0);
signal t_ddr2_ras_n:    std_logic;
signal t_ddr2_cas_n:    std_logic;
signal t_ddr2_we_n:    	std_logic;
signal t_ddr2_cs_n:    	std_logic_vector((CS_WIDTH-1) downto 0);
signal t_ddr2_odt:   	std_logic_vector((ODT_WIDTH-1) downto 0);
signal t_ddr2_cke:    	std_logic_vector((CKE_WIDTH-1) downto 0);
signal t_ddr2_dm:    	std_logic_vector((DM_WIDTH-1) downto 0);
signal t_ddr2_dqs:   	std_logic_vector((DQS_WIDTH-1) downto 0);
signal t_ddr2_dqs_n:   	std_logic_vector((DQS_WIDTH-1) downto 0);
signal t_ddr2_ck:    	std_logic_vector((CLK_WIDTH-1) downto 0);
signal t_ddr2_ck_n:    	std_logic_vector((CLK_WIDTH-1) downto 0);



begin

-- PLL --------------------------------------------------

Inst_PLL_DDR_SYSTEM_CLK: PLL_DDR_SYSTEM_CLK PORT MAP(
		CLKIN1_IN => clk_ext,
		CLKOUT0_OUT => clk_133,
		CLKOUT1_OUT => clk_200,
		CLKOUT2_OUT => clk_266,
		LOCKED_OUT => PLL_locked
	);

-- Memory Conroller ------------------------------------

u_MEMORY_CONTROLLER_TEST : MEMORY_CONTROLLER_TEST
generic map (
     BANK_WIDTH => BANK_WIDTH,
     CKE_WIDTH => CKE_WIDTH,
     CLK_WIDTH => CLK_WIDTH,
     COL_WIDTH => COL_WIDTH,
     CS_NUM => CS_NUM,
     CS_WIDTH => CS_WIDTH,
     CS_BITS => CS_BITS,
     DM_WIDTH => DM_WIDTH,
     DQ_WIDTH => DQ_WIDTH,
     DQ_PER_DQS => DQ_PER_DQS,
     DQS_WIDTH => DQS_WIDTH,
     DQ_BITS => DQ_BITS,
     DQS_BITS => DQS_BITS,
     ODT_WIDTH => ODT_WIDTH,
     ROW_WIDTH => ROW_WIDTH,
     ADDITIVE_LAT => ADDITIVE_LAT,
     BURST_LEN => BURST_LEN,
     BURST_TYPE => BURST_TYPE,
     CAS_LAT => CAS_LAT,
     ECC_ENABLE => ECC_ENABLE,
     APPDATA_WIDTH => APPDATA_WIDTH,
     MULTI_BANK_EN => MULTI_BANK_EN,
     TWO_T_TIME_EN => TWO_T_TIME_EN,
     ODT_TYPE => ODT_TYPE,
     REDUCE_DRV => REDUCE_DRV,
     REG_ENABLE => REG_ENABLE,
     TREFI_NS => TREFI_NS,
     TRAS => TRAS,
     TRCD => TRCD,
     TRFC => TRFC,
     TRP => TRP,
     TRTP => TRTP,
     TWR => TWR,
     TWTR => TWTR,
     HIGH_PERFORMANCE_MODE => HIGH_PERFORMANCE_MODE,
     SIM_ONLY => SIM_ONLY,
     DEBUG_EN => DEBUG_EN,
     CLK_PERIOD => CLK_PERIOD,
     DLL_FREQ_MODE => DLL_FREQ_MODE,
     CLK_TYPE => CLK_TYPE,
     NOCLK200 => NOCLK200,
     RST_ACT_LOW => RST_ACT_LOW
)
port map (
-- memory signals---------------------------------------
   ddr2_dq                    => t_ddr2_dq,
   ddr2_a                     => t_ddr2_a,
   ddr2_ba                    => t_ddr2_ba,
   ddr2_ras_n                 => t_ddr2_ras_n,
   ddr2_cas_n                 => t_ddr2_cas_n,
   ddr2_we_n                  => t_ddr2_we_n,
   ddr2_cs_n                  => t_ddr2_cs_n,
   ddr2_odt                   => t_ddr2_odt,
   ddr2_cke                   => t_ddr2_cke,
   ddr2_dm                    => t_ddr2_dm,
	ddr2_dqs                   => t_ddr2_dqs,
   ddr2_dqs_n                 => t_ddr2_dqs_n,
   ddr2_ck                    => t_ddr2_ck,
   ddr2_ck_n                  => t_ddr2_ck_n,
-- clocks-------------------------------------------------
   sys_clk                    => clk_133,
   idly_clk_200               => clk_200,
   sys_rst_n                  => ext_reset,
-- userinterface-------------------------------------------
   phy_init_done              => test_ddr_init_done,	-- 
   rst0_tb                    => test_rst0_tb, -- 
   clk0_tb                    => test_ddr_clk_uif,   -- 
   app_wdf_afull              => test_ddr_wdf_full,	-- write data FIFO full
   app_af_afull               => test_ddr_af_full,		-- adress FIFO full
   rd_data_valid              => t_ram_data_valid, 	--
   app_wdf_wren               => '0',  					--  WE -> Daten in FIFO schreiben
   app_af_wren                => t_ram_rd_en,			--  WE -> Addresse in FIFO schreiben
   app_af_addr                => t_ram_rd_adr,			--  Read Addresse 
   app_af_cmd                 => "001",					--  command 
   rd_data_fifo_out           => t_ram_data, 			-- NC Read Daten
   app_wdf_data               => (others => '0'),		--app_wdf_data,		-- NC Wrie Daten
   app_wdf_mask_data          => (others => '0')		--app_wdf_mask_data	-- NC Write Data Mask
);

Inst_ddr2_model: ddr2_model 
generic map (
     BANK_WIDTH => BANK_WIDTH,
     CKE_WIDTH => CKE_WIDTH,
     CLK_WIDTH => CLK_WIDTH,
     COL_WIDTH => COL_WIDTH,
     CS_NUM => CS_NUM,
     CS_WIDTH => CS_WIDTH,
     CS_BITS => CS_BITS,
     DM_WIDTH => DM_WIDTH,
     DQ_WIDTH => DQ_WIDTH,
     DQ_PER_DQS => DQ_PER_DQS,
     DQS_WIDTH => DQS_WIDTH,
     DQ_BITS => DQ_BITS,
     DQS_BITS => DQS_BITS,
     ODT_WIDTH => ODT_WIDTH,
     ROW_WIDTH => ROW_WIDTH,
     ADDITIVE_LAT => ADDITIVE_LAT,
     BURST_LEN => BURST_LEN,
     BURST_TYPE => BURST_TYPE,
     CAS_LAT => CAS_LAT,
     ECC_ENABLE => ECC_ENABLE,
     APPDATA_WIDTH => APPDATA_WIDTH,
     MULTI_BANK_EN => MULTI_BANK_EN,
     TWO_T_TIME_EN => TWO_T_TIME_EN,
     ODT_TYPE => ODT_TYPE,
     REDUCE_DRV => REDUCE_DRV,
     REG_ENABLE => REG_ENABLE,
     TREFI_NS => TREFI_NS,
     TRAS => TRAS,
     TRCD => TRCD,
     TRFC => TRFC,
     TRP => TRP,
     TRTP => TRTP,
     TWR => TWR,
     TWTR => TWTR,
     HIGH_PERFORMANCE_MODE => HIGH_PERFORMANCE_MODE,
     SIM_ONLY => SIM_ONLY,
     DEBUG_EN => DEBUG_EN,
     CLK_PERIOD => CLK_PERIOD,
     DLL_FREQ_MODE => DLL_FREQ_MODE,
     CLK_TYPE => CLK_TYPE,
     NOCLK200 => NOCLK200,
     RST_ACT_LOW => RST_ACT_LOW
)

PORT MAP(

		ck => t_ddr2_ck,
		ck_n => t_ddr2_ck_n,
		cke => t_ddr2_cke,
		cs_n => t_ddr2_cs_n,
		ras_n => t_ddr2_ras_n,
		cas_n => t_ddr2_cas_n,
		we_n => t_ddr2_we_n,
		dm_rdqs => t_ddr2_dm,
		ba => t_ddr2_ba,
		addr => t_ddr2_a,
		dq => t_ddr2_dq,
		dqs => t_ddr2_dqs,
		dqs_n => t_ddr2_dqs_n,
		rdqs_n => test_rdqs_n,
		odt => t_ddr2_odt
	);




end Behavioral;

