#include <avr/io.h>
#include <avr/interrupt.h>
#include <inttypes.h>
#include <stdio.h>
#include "rtc.h"
#include "lcd.h"
#	define USR UCSR1A
#	define UCR UCSR1B
#	define UDR UDR1
#	define UBRR UBRR1L
#	define EICR EICRB
#define SYSCLK	16000000	//Quarz Frequenz in Hz

//Die Baud_Rate der Seriellen Schnittstelle ist 9600 Baud
#define BAUD_RATE 9600		//Baud Rate fr die Serielle Schnittstelle	

void IOInit (void)
{
	//Enable TXEN im Register UCR TX-Data Enable
	UCR=(1 << TXEN);
	//Teiler wird gesetzt 
	UBRR=(SYSCLK / (BAUD_RATE * 16L) - 1);
}

int uart_putchar (char c)
{
	if (c == '\n')
		uart_putchar('\r');
	//Warten solange bis Zeichen gesendet wurde
	loop_until_bit_is_set(USR, UDRE);
	UDR = c;
	return (0);
}

void main()
{

  int temp0,temp1;   
cli();
   for(temp0=0;temp0<0x0040;temp0++)   // Wait for external clock crystal to stabilize
    {
        for(temp1=0;temp1<0xFFFF;temp1++);
    }
   // DDRB=0xFF;           
    TIMSK &=~((1<<TOIE0)|(1<<OCIE0));     //Disable TC0 interrupt
    ASSR |= (1<<AS0);           //set Timer/Counter0 to be asynchronous from the CPU clock 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //with a second external clock(32,768kHz)driving it.  
    TCNT0 = 0x00;
    TCCR0 = 0x05;                 //prescale the timer to be clock source / 128 to make it
                                //exactly 1 second for every overflow to occur
    while(ASSR&0x07);           //Wait until TC0 is updated
    
 
	
	TIMSK |= (1<<TOIE0);        //set 8-bit Timer/Counter0 Overflow Interrupt Enable                             

 


sei();
//DDRC  &= ~(1<<DDC6);  /* Pin PC7 als Eingang */

lcd_init(LCD_DISP_ON);
lcd_clrscr(); 
init_SPI_rtc();
set_square_out();
set_rtc_second(00);
set_rtc_minute(13);
set_rtc_hour(19);
while(1)
{
}




}

 SIGNAL( TIMER0_OVF_vect )
 { 
read_rtc_second();
}
									   
