#include <stdio.h>
#include "lcd.h"
#include "rtc.h"



void init_SPI_rtc()
{
	SPI_Direction_REG &=~(1<<SPI_DI);			
	SPI_Direction_REG |= (1<<SPI_Clock);		
	SPI_Direction_REG |= (1<<SPI_DO);			
	SPI_Direction_REGCSC |= (1<<rtccs);	
	SPI_Direction_REG |= (1<<SPI_SS);	
	SPI_WriteCSC |= (1<<rtccs);			


		SPCR = (1<<SPE)|(1<<MSTR)|(1<<CPHA)|(0<<SPR0)|(0<<SPR1); 
		//SPI CLK=4MHZ
		
		
		}


//SET OUTPUT SQUAREWAVE 34,xxKJZ

void set_square_out()
{
rtc_low();
Write_SPI(0x8d);
read_SPI();
Write_SPI(0x18);
read_SPI();
rtc_height();
}


void set_rtc_second(unsigned char sec)
{
rtc_low();
Write_SPI(0x81);
read_SPI();
Write_SPI(sec);
read_SPI();
rtc_height();
}

void set_rtc_minute(unsigned char min)
{
rtc_low();
Write_SPI(0x82);
read_SPI();
Write_SPI(min);
read_SPI();
rtc_height();
}
void set_rtc_hour(unsigned char hour)
{
rtc_low();
Write_SPI(0x83);
read_SPI();
Write_SPI(hour+64);
read_SPI();
rtc_height();
}

unsigned char read_rtc_second()
{
unsigned char second;
rtc_low();
Write_SPI(0x01);
read_SPI();
Write_SPI(0xff);//dummy
second=read_SPI();
lcd_gotoxy(0,1);
rtc_height();
char buffer[30];
sprintf(buffer,"sec%d",second);
lcd_puts(buffer);
return second;
}

unsigned char read_rtc_minute()
{
unsigned char minute;
rtc_low();
Write_SPI(0x02);
read_SPI();
Write_SPI(0xff);
minute=read_SPI();
rtc_height();
return minute;
}

unsigned char read_rtc_hour()
{
unsigned char hour;
rtc_low();
Write_SPI(0x03);
read_SPI();
Write_SPI(0xff);
hour=read_SPI();
rtc_height();
return hour;
}




//WIRTE READ SEQUENCE OF SPI


unsigned char read_SPI()
{
while(!(SPSR & (1<<SPIF)));
return SPDR;
}



void Write_SPI(unsigned char data)
{SPDR=data;
while(!(SPSR & (1<<SPIF)));
}

