package gui;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

import util.FontChar;
import util.LCDFont;

public class CharList implements MouseListener {
	private CharEditor charEdit;
	private DefaultTableColumnModel columnModel;
	private DefaultTableModel tableModel;
	private JTable charTable;
	private LCDFont font;
	
	public CharList(LCDFont font, FontEditor fontEdit){
		this.charEdit = fontEdit.getCharEditor();
		this.font = font;
		columnModel = new DefaultTableColumnModel();

		TableColumn num = new TableColumn(0, 30); 
		num.setHeaderValue("Dec");
		columnModel.addColumn(num);
		TableColumn hex = new TableColumn(1, 35);
		hex.setHeaderValue("Hex"); 
		columnModel.addColumn(hex);
		TableColumn ascii = new TableColumn(2, 37);
		ascii.setHeaderValue("ASCII"); 
		columnModel.addColumn(ascii);
		TableColumn desc = new TableColumn(4, 93);
		desc.setHeaderValue("Kommentar"); 
		columnModel.addColumn(desc);
		
		tableModel = new DefaultTableModel();
		tableModel.setColumnCount(5);
		
		charTable = new JTable(tableModel, columnModel);
		charTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		charTable.setMinimumSize(new Dimension(225, 100));
		charTable.addMouseListener(this);
		rowData(font);
	}
	
	public JTable getTable(){
		return charTable;
	}
	
	private void rowData(LCDFont font){
		for (int i = font.getGenerateStartIndex(); i < font.getGenerateCount()+font.getGenerateStartIndex(); i++) {
			String hexVal = (Integer.toHexString(i)).toUpperCase();
			if(hexVal.length() == 1)
				hexVal = "0"+hexVal;
			
			String asciiC = "";
			asciiC = ""+(char)i;
			
			Object[] tableData = {
				""+i,
				"0x"+hexVal,
				asciiC,
				"bla"
			};
			tableModel.addRow(tableData);
		}
		charTable.setRowSelectionInterval(0,0);
		
	}
	
	public int getSelectedIndex(){
		return charTable.getSelectedRow();
	}

	public void mouseClicked(MouseEvent e) {
		//System.out.println(charTable.getSelectedRow());
		//System.out.println(font.getFontChar(charTable.getSelectedRow()));
		charEdit.setFontChar(font.getFontChar(charTable.getSelectedRow()));
	}

	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void mouseReleased(MouseEvent e) {
		
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub
		
	}
}
