package gui;


import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

import util.FontChar;
import util.LCDFont;

public class FontEditor extends JInternalFrame implements InternalFrameListener{

	private JSplitPane contentPane = null;
	private JScrollPane scrollPane;
	
	private MainFrame mainFrame;
	
	private CharList charList;
	private JScrollPane charListScrollPane;
	
	private CharEditor charEdit;
	
	private LCDFont font;
	
	
	static int openFrameCount = 0;
	static final int xOffset = 30, yOffset = 30;

	public static boolean unsavedChanges = false;
	
	
	public FontEditor(LCDFont font,MainFrame mainFrame) {
		super(font.getName(),
		          false, //resizable
		          true, //closable
		          true, //maximizable
		          true);//iconifiable
		this.font = font;
		this.mainFrame = mainFrame;
		++openFrameCount;
		setLocation(xOffset*(openFrameCount-1), yOffset*(openFrameCount-1));
		setLayer(openFrameCount);
		init();
		frame_init();
		gui_init();
	}
	
	public LCDFont getLCDFont(){
		return font;
	}
	
	public CharEditor getCharEditor(){
		return charEdit;
	}
	
	private void init() {
		int w = font.getFontMetrics().width*font.getBigFontX();
		int h = font.getFontMetrics().height*font.getBigFontY();
		for (int i = 0; i < font.getGenerateCount(); i++) {
			Pixel[][] pixel = new Pixel[w][h];
			BufferedImage buffImg = new BufferedImage(w,h,BufferedImage.TYPE_BYTE_INDEXED);
			Graphics g = buffImg.getGraphics();
			g.setColor(Color.WHITE);
			g.fillRect(0,0,w,h);
			if (font.getImportedFont()!=null) {
				g.setColor(Color.BLACK);
				g.setFont(font.getImportedFont());
				g.drawString((char)(i+font.getGenerateStartIndex())+"",0,(int) (g.getFontMetrics().getStringBounds((char)(i+font.getGenerateStartIndex())+"",g).getHeight()*0.625)+1);
			}
			for (int j = 0; j < w; j++) {
				for (int k = 0; k < h; k++) {
					pixel[j][k] = new Pixel();
					pixel[j][k].setColor(new Color(buffImg.getRGB(j,k)));
				}
			}
			FontChar fontChar = new FontChar(pixel);
			font.setFontChar(fontChar,i);
		}		
	}
	private void gui_init() {
		
		
		contentPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		contentPane.setOneTouchExpandable(true);
		
		scrollPane = new JScrollPane();
		charEdit = new CharEditor(font,mainFrame);
		scrollPane.setViewportView(charEdit);	
		contentPane.setLeftComponent(scrollPane);
		charEdit.setFontChar(font.getFontChar(0));
				
		charList = new CharList(font,this);
		charListScrollPane = new JScrollPane();
		charListScrollPane.setViewportView(charList.getTable());
		contentPane.setRightComponent(charListScrollPane);
		
		
		
		contentPane.setDividerLocation(300);
		

		this.setContentPane(contentPane);
	}

	public FontEditor getFontEditor(){
		return this;
	}
	
	private void frame_init() {
		this.setSize(500, 300);
		this.addInternalFrameListener(this);
	}



	public void internalFrameOpened(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void internalFrameClosing(InternalFrameEvent e) {
		--openFrameCount;
		
	}

	public void internalFrameClosed(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void internalFrameIconified(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void internalFrameDeiconified(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void internalFrameActivated(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void internalFrameDeactivated(InternalFrameEvent e) {
		// TODO Auto-generated method stub
		
	}
}  //  @jve:decl-index=0:visual-constraint="10,10"
