package gui;

import java.awt.event.KeyEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.BorderLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;

import javax.swing.ButtonGroup;
import javax.swing.KeyStroke;
import javax.swing.JPanel;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JDesktopPane;
import javax.swing.JToolBar;
import javax.swing.JToggleButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.BoxLayout;

public class MainFrame extends JFrame {

	private JMenuBar menuBar = null;

	private JMenu fileMenu = null;

	private JMenu editMenu = null;

	private JMenu helpMenu = null;

	private JMenuItem exitMenuItem = null;

	private JMenuItem aboutMenuItem = null;

	private JMenuItem cutMenuItem = null;

	private JMenuItem copyMenuItem = null;

	private JMenuItem pasteMenuItem = null;

	private JMenuItem saveMenuItem = null;

	private JMenuItem newMenuItem = null;

	private JPanel jContentPane = null;

	private JToolBar toolBar = null;

	private JDesktopPane editorFramePane = null;

	private JToggleButton penButton = null;

	private JToggleButton lineButton = null;

	private JToggleButton rectButton = null;

	private JToolBar penPropertyBar = null;

	private JToggleButton smallButton = null;

	private JToggleButton bigButton = null;
	
	private JToggleButton ellipseButton = null;

	private JMenu optionsMenuItem = null;

	private JPanel statusPanel = null;

	private JCheckBox filledBox = null;
	
	
	
	public static final int TOOL_PEN = 1;
	public static final int TOOL_LINE = 2;
	public static final int TOOL_RECT = 3;
	public static final int TOOL_RECT_FILLED = 4;
	public static final int TOOL_ELIPSE = 5;
	public static final int TOOL_ELIPSE_FILLED = 6;
	public static int tool = TOOL_PEN;

	private JLabel statusLabel = null;
	

	/**
	 * This method initializes newMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getNewMenuItem() {
		if (newMenuItem == null) {
			newMenuItem = new JMenuItem();
			newMenuItem.setText("Neu");
			newMenuItem.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					NewFontDialog nfd = new NewFontDialog(MainFrame.this);
					
					if (nfd.showNewFontDialog()==NewFontDialog.APPROVE_OPTION) {
						
						FontEditor aCharEditor = new FontEditor(nfd.getLCDFont(),MainFrame.this);
						aCharEditor.setVisible(true);
						editorFramePane.add(aCharEditor);
						try {
							aCharEditor.setSelected(true);
						} catch (PropertyVetoException e1) {
							// Ignore
						}
					}
					
					
					
					
				}
			});
		}
		return newMenuItem;
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJToolBar(), java.awt.BorderLayout.NORTH);
			jContentPane.add(getPenPropertyBar(), java.awt.BorderLayout.WEST);
			jContentPane.add(getEditorFramePane(), java.awt.BorderLayout.CENTER);
			jContentPane.add(getStatusPanel(), java.awt.BorderLayout.SOUTH);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jToolBar	
	 * 	
	 * @return javax.swing.JToolBar	
	 */
	private JToolBar getJToolBar() {
		if (toolBar == null) {
			toolBar = new JToolBar();
			toolBar.add(getPenButton());
			toolBar.add(getLineButton());
			toolBar.add(getRectButton());
			toolBar.add(getEllipseButton());
			ButtonGroup group = new ButtonGroup();
			group.add(penButton);
			group.add(lineButton);
			group.add(rectButton);
			group.add(ellipseButton); 
		}
		return toolBar;
	}

	/**
	 * This method initializes EditorFramePane	
	 * 	
	 * @return javax.swing.JDesktopPane	
	 */
	private JDesktopPane getEditorFramePane() {
		if (editorFramePane == null) {
			editorFramePane = new JDesktopPane();
		}
		return editorFramePane;
	}

			
	/**
	 * This method initializes Pen	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getPenButton() {
		if (penButton == null) {
			penButton = new JToggleButton();
			penButton.setText("Stift");	
			penButton.setSelected(true);
			penButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					filledBox.setEnabled(false);
					tool=TOOL_PEN;
				}
			});
		}
		return penButton;
	}

	/**
	 * This method initializes jToggleButton	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getLineButton() {
		if (lineButton == null) {
			lineButton = new JToggleButton();
			lineButton.setText("Linie");
			lineButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					filledBox.setEnabled(false);
					tool = TOOL_LINE;
				}
			});
		}
		return lineButton;
	}

	/**
	 * This method initializes rect	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getRectButton() {
		if (rectButton == null) {
			rectButton = new JToggleButton();
			rectButton.setText("Rechteck");
			rectButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					filledBox.setEnabled(true);
					if (filledBox.isSelected()) {
						tool = TOOL_RECT_FILLED;
					}else{
						tool = TOOL_RECT;
					}
				}
			});
		}
		return rectButton;
	}

	/**
	 * This method initializes jJToolBarBar	
	 * 	
	 * @return javax.swing.JToolBar	
	 */
	private JToolBar getPenPropertyBar() {
		if (penPropertyBar == null) {
			penPropertyBar = new JToolBar();
			penPropertyBar.setOrientation(javax.swing.JToolBar.VERTICAL);
			penPropertyBar.add(getSmallButton());
			penPropertyBar.add(getBigButton());
			ButtonGroup sizeButtonGroup = new ButtonGroup();
			sizeButtonGroup.add(smallButton);
			sizeButtonGroup.add(bigButton);
			penPropertyBar.add(getFilledBox());
			
		}
		return penPropertyBar;
	}

	/**
	 * This method initializes smallButton	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getSmallButton() {
		if (smallButton == null) {
			smallButton = new JToggleButton();
			smallButton.setText("klein");
			smallButton.setSelected(true);
		}
		return smallButton;
	}

	/**
	 * This method initializes jToggleButton	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getBigButton() {
		if (bigButton == null) {
			bigButton = new JToggleButton();
			bigButton.setText("gro");
		}
		return bigButton;
	}

	/**
	 * This method initializes optionsMenuItem	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getOptionsMenuItem() {
		if (optionsMenuItem == null) {
			optionsMenuItem = new JMenu();
			optionsMenuItem.setText("Optionen");
		}
		return optionsMenuItem;
	}

	/**
	 * This method initializes statusPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getStatusPanel() {
		if (statusPanel == null) {
			statusLabel = new JLabel();
			statusLabel.setText("");
			statusLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
			statusPanel = new JPanel();
			statusPanel.setLayout(new BoxLayout(getStatusPanel(), BoxLayout.X_AXIS));
			statusPanel.add(statusLabel, null);
		}
		return statusPanel;
	}

	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getFilledBox() {
		if (filledBox == null) {
			filledBox = new JCheckBox();
			filledBox.setText("Gefllt");
			filledBox.setEnabled(false);
			filledBox.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (rectButton.isSelected()) {
						if (filledBox.isSelected()) {
							tool = TOOL_RECT_FILLED;
						}else{
							tool = TOOL_RECT;
						}
					}else if(ellipseButton.isSelected()){
						if (filledBox.isSelected()) {
							tool = TOOL_ELIPSE_FILLED;
						}else{
							tool = TOOL_ELIPSE;
						}
					}
				}
			});
		}
		return filledBox;
	}

	/**
	 * This method initializes elipseButton	
	 * 	
	 * @return javax.swing.JToggleButton	
	 */
	private JToggleButton getEllipseButton() {
		if (ellipseButton == null) {
			ellipseButton = new JToggleButton();
			ellipseButton.setText("Ellipse");
			ellipseButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					filledBox.setEnabled(true);
					if (filledBox.isSelected()) {
						tool = TOOL_ELIPSE_FILLED;
					}else{
						tool = TOOL_ELIPSE;
					}
				}
			});
		}
		return ellipseButton;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		MainFrame application = new MainFrame();
		application.setVisible(true);
	}

	/**
	 * This is the default constructor
	 */
	public MainFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setContentPane(getJContentPane());
		this.setJMenuBar(getJJMenuBar());
		this.setSize(662, 435);
		this.setTitle("Application");
		this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight()/2-this.getHeight()/2),(int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth()/2-this.getWidth()/2));
		this.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				// TODO Ask for Save
			}
		});
	}

	/**
	 * This method initializes jJMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getJJMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getFileMenu());
			menuBar.add(getEditMenu());
			menuBar.add(getOptionsMenuItem());
			menuBar.add(getHelpMenu());
		}
		return menuBar;
	}

	/**
	 * This method initializes jMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText("Datei");
			fileMenu.add(getNewMenuItem());
			fileMenu.add(getSaveMenuItem());
			fileMenu.add(getExitMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes jMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getEditMenu() {
		if (editMenu == null) {
			editMenu = new JMenu();
			editMenu.setText("Bearbeiten");
			editMenu.add(getCutMenuItem());
			editMenu.add(getCopyMenuItem());
			editMenu.add(getPasteMenuItem());
		}
		return editMenu;
	}

	/**
	 * This method initializes jMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getHelpMenu() {
		if (helpMenu == null) {
			helpMenu = new JMenu();
			helpMenu.setText("Hilfe");
			helpMenu.add(getAboutMenuItem());
		}
		return helpMenu;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getExitMenuItem() {
		if (exitMenuItem == null) {
			exitMenuItem = new JMenuItem();
			exitMenuItem.setText("Beenden");
			exitMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					//TODO Ask for Save
					System.exit(0);
				}
			});
		}
		return exitMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getAboutMenuItem() {
		if (aboutMenuItem == null) {
			aboutMenuItem = new JMenuItem();
			aboutMenuItem.setText("About");
			aboutMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					// TODO: Add About Window
				}
			});
		}
		return aboutMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getCutMenuItem() {
		if (cutMenuItem == null) {
			cutMenuItem = new JMenuItem();
			cutMenuItem.setText("Cut");
			cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,
					Event.CTRL_MASK, true));
		}
		return cutMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getCopyMenuItem() {
		if (copyMenuItem == null) {
			copyMenuItem = new JMenuItem();
			copyMenuItem.setText("Copy");
			copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C,
					Event.CTRL_MASK, true));
		}
		return copyMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getPasteMenuItem() {
		if (pasteMenuItem == null) {
			pasteMenuItem = new JMenuItem();
			pasteMenuItem.setText("Paste");
			pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V,
					Event.CTRL_MASK, true));
		}
		return pasteMenuItem;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getSaveMenuItem() {
		if (saveMenuItem == null) {
			saveMenuItem = new JMenuItem();
			saveMenuItem.setText("Speichern");
			saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,
					Event.CTRL_MASK, true));
		}
		return saveMenuItem;
	}
	
	public void setStatusLabelText(String text){
		statusLabel.setText(text);
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
