package gui;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import util.LCDFont;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;

public class NewFontDialog extends JDialog implements ActionListener, ItemListener, ChangeListener{
	
	private JPanel contentPane;
	private JPanel generalPanel;
	private JTextField fontNameTxt;
	private JLabel fontNameL;
	private JLabel fontMetricsL;
	private JRadioButton fontMetrics_6x8;
	private JRadioButton fontMetrics_8x8;
	private JCheckBox bigFontBox;
	private JSpinner bigFont_x;
	private JSpinner bigFont_y;
	private JLabel bigFontL;
	private JCheckBox generateChars;
	private JLabel startIndexL;
	private JSpinner generateStartIndex;
	private JLabel countL;
	private JSpinner generateCount;
	
	private JPanel importFontPanel;
	private Choice fontChoice;
	private JCheckBox boldBox;
	private JCheckBox italicBox;
	private JPanel fontPreviewPane;
	private Graphics fontPreviewPaneGraphics;
	
	private JPanel controlButtonPanel;
	private JButton okButton;
	private JButton cancelButton;

	private int style;
	private int returnValue;
	private LCDFont font;
	
	public static final int APPROVE_OPTION = 1;
	public static final int CANCEL_OPTION = 0;

	public NewFontDialog(JFrame parent) {
		super(parent);
		Dialog_init();
		GUI_init();
		
	}
	
	private void GUI_init(){
		
		//################ General Settings Panel ####################
		generalPanel = new JPanel();
		generalPanel.setLayout(null);
		generalPanel.setBorder(BorderFactory.createTitledBorder(null,"Allgemein"));
		generalPanel.setBounds(5,5,200,200);
		generalPanel.setPreferredSize(new Dimension(180,270));
		
		fontNameL = new JLabel("Name: ");
		fontNameL.setBounds(15, 30, 71, 16);
		generalPanel.add(fontNameL);
		
		fontNameTxt = new JTextField("Neue Schriftart");
		fontNameTxt.setPreferredSize(new Dimension(50,20));
		fontNameTxt.setBounds(60, 30, 106, 16);
		generalPanel.add(fontNameTxt);
		
		fontMetricsL = new JLabel("Gre:");
		fontMetricsL.setBounds(15, 60, 46, 16);
		generalPanel.add(fontMetricsL, fontMetricsL.getName());
		
		fontMetrics_6x8 = new JRadioButton();
		fontMetrics_6x8.setBounds(60, 60, 46, 16);
		fontMetrics_6x8.setText("6x8");
		fontMetrics_6x8.setSelected(true);
		generalPanel.add(fontMetrics_6x8);
		
		fontMetrics_8x8 = new JRadioButton();
		fontMetrics_8x8.setBounds(105,60,46,16);
		fontMetrics_8x8.setText("8x8");
		generalPanel.add(fontMetrics_8x8);
		
		ButtonGroup fontMetricsButtonsGroup = new ButtonGroup();
		fontMetricsButtonsGroup.add(fontMetrics_6x8);
		fontMetricsButtonsGroup.add(fontMetrics_8x8);
		
		bigFontBox = new JCheckBox();
		bigFontBox.setBounds(15, 105, 76, 16);
		bigFontBox.setText("BigFont");
		bigFontBox.addActionListener(this);
		generalPanel.add(bigFontBox);
		
		bigFont_x = new JSpinner(new SpinnerNumberModel(1,1,5,1));
		bigFont_x.setBounds(15, 135, 31, 16);
		bigFont_x.setEnabled(bigFontBox.isSelected());
		generalPanel.add(bigFont_x);
		
		bigFontL = new JLabel("x");
		bigFontL.setBounds(60, 135, 16, 16);
		generalPanel.add(bigFontL);
		
		bigFont_y = new JSpinner(new SpinnerNumberModel(1,1,5,1));
		bigFont_y.setBounds(75, 135, 31, 16);
		bigFont_y.setEnabled(bigFontBox.isSelected());
		generalPanel.add(bigFont_y);
		
		generateChars = new JCheckBox("Zeichen generieren");
		generateChars.setSelected(true);
		generateChars.addActionListener(this);
		generateChars.setBounds(new java.awt.Rectangle(15,180,136,16));
		generalPanel.add(generateChars);
		
		startIndexL = new JLabel("Start Index:");
		startIndexL.setEnabled(true);
		startIndexL.setBounds(new java.awt.Rectangle(15,210,91,16));
		generalPanel.add(startIndexL);
		
		generateStartIndex = new JSpinner();
		generateStartIndex.setEnabled(true);
		generateStartIndex.setModel(new SpinnerNumberModel(32,0,255,1));
		generateStartIndex.setBounds(new java.awt.Rectangle(105,210,46,16));
		generateStartIndex.addChangeListener(this);
		generalPanel.add(generateStartIndex);
		
		countL = new JLabel("Anzahl:");
		countL.setEnabled(true);
		countL.setBounds(new java.awt.Rectangle(15,240,91,16));
		generalPanel.add(countL);
		
		generateCount = new JSpinner();
		generateCount.setEnabled(true);
		generateCount.setModel(new SpinnerNumberModel(96,1,255-((Integer)generateStartIndex.getValue()).intValue(),1));
		generateCount.addChangeListener(this);
		generateCount.setBounds(new java.awt.Rectangle(105,240,46,16));
		generalPanel.add(generateCount);
		
		//############################################################
		
		//################ importFontsPanel ##########################
		importFontPanel = new JPanel();
		importFontPanel.setBorder(BorderFactory.createTitledBorder(null,"Schriftart Importieren"));
		importFontPanel.setPreferredSize(new Dimension(200,150));
		
		fontChoice = new Choice();
		fontChoice.setPreferredSize(new Dimension(180,20));
		GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
		String[] fontNames = graphEnv.getAvailableFontFamilyNames();
		fontChoice.add("Keine");
		for (int i = 0; i < fontNames.length; i++) {
			fontChoice.add(fontNames[i]);
		}
		fontChoice.addItemListener(this);
		importFontPanel.add(fontChoice);
		
		boldBox = new JCheckBox();
		boldBox.setText("Fett");
		boldBox.addActionListener(this);
		boldBox.setEnabled(false);
		importFontPanel.add(boldBox);
		
		italicBox = new JCheckBox();
		italicBox.setText("Kusiv");
		italicBox.addActionListener(this);
		italicBox.setEnabled(false);
		importFontPanel.add(italicBox);
		
		fontPreviewPane = new JPanel();
		fontPreviewPane.setPreferredSize(new Dimension(180,30));
		importFontPanel.add(fontPreviewPane);
		//############################################################
		
		//################ Controll Buttons (Ok / Cancel) ############
		controlButtonPanel = new JPanel();
		
		okButton = new JButton("Ok");
		okButton.addActionListener(this);
		controlButtonPanel.add(okButton);
		
		cancelButton =new JButton("Abbrechen");
		cancelButton.addActionListener(this);
		controlButtonPanel.add(cancelButton);
		//############################################################
		
		//################ Add Panels to ContentPane #################
		contentPane = new JPanel(new BorderLayout());
		contentPane.add(generalPanel,BorderLayout.WEST);
		contentPane.add(importFontPanel,BorderLayout.EAST);
		contentPane.add(controlButtonPanel,BorderLayout.SOUTH);			
		this.setContentPane(contentPane);
		pack();
		//############################################################
	}
	
	private void Dialog_init(){
		this.setSize(300,200);
		this.setTitle("Neue Schrift");
		this.setModal(true);
		this.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight()/2-this.getHeight()/2),(int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth()/2-this.getWidth()/2));
		this.setResizable(false);
	}

	public void actionPerformed(ActionEvent e) {
		String actionCommand = e.getActionCommand();
		if (actionCommand.equalsIgnoreCase("BigFont")) {
			bigFont_x.setEnabled(bigFontBox.isSelected());
			bigFont_y.setEnabled(bigFontBox.isSelected());
		}
		
		if (actionCommand.equalsIgnoreCase("fett")||actionCommand.equalsIgnoreCase("kusiv")) {
			repaint();
		}
		
		if (actionCommand.equalsIgnoreCase("zeichen generieren")) {
			generateStartIndex.setEnabled(generateChars.isSelected());
			generateCount.setEnabled(generateChars.isSelected());
			startIndexL.setEnabled(generateChars.isSelected());
			countL.setEnabled(generateChars.isSelected());
		}
		
		boolean allIsCorrect=true;
		if (actionCommand.equalsIgnoreCase("ok")) {
			
			font = new LCDFont();
			
			if (fontNameTxt.getText().length()>0) {
				font.setName(fontNameTxt.getText());
			}else{
				allIsCorrect=false;
				fontNameTxt.requestFocus();
			}
			
			if (fontMetrics_6x8.isSelected()) {
				font.setFontMetrics(new Dimension(6,8));
			}else{
				font.setFontMetrics(new Dimension(8,8));
			}
			
			if (bigFontBox.isSelected()) {
				
				font.setBigFontX(((Integer)bigFont_x.getValue()).intValue());
				font.setBigFontY(((Integer)bigFont_y.getValue()).intValue());
			}else{
				font.setBigFontX(1);
				font.setBigFontY(1);
			}
			
			if (!fontChoice.getSelectedItem().equalsIgnoreCase("keine")) {
				font.setImportedFont(new Font(fontChoice.getSelectedItem(),style,8*font.getBigFontX()));
			}
			
			if (generateChars.isSelected()) {
				font.setGenerateStartIndex(((Integer)generateStartIndex.getValue()).intValue());
				font.setGenerateCount(((Integer)generateCount.getValue()).intValue());
			}else{
				font.setGenerateStartIndex(0);
				font.setGenerateCount(1);
			}
			

			if (allIsCorrect) {
				returnValue=APPROVE_OPTION;
				
				dispose();
			}
			
		}
		if (actionCommand.equalsIgnoreCase("abbrechen")) {
			returnValue=CANCEL_OPTION;
			dispose();
		}
	}

	public void itemStateChanged(ItemEvent e) {
		if (! ( (String)e.getItem() ).equalsIgnoreCase("keine") ) {
			boldBox.setEnabled(true);
			italicBox.setEnabled(true);
		}else{
			boldBox.setEnabled(false);
			italicBox.setEnabled(false);
		}
		repaint();
	}
	
	public void paint(Graphics g){
		super.paint(g);
		
		if (!fontChoice.getSelectedItem().equalsIgnoreCase("keine")) {
			style = Font.PLAIN;
			fontPreviewPaneGraphics = fontPreviewPane.getGraphics();
			
			fontPreviewPaneGraphics.setColor(new Color(184,207,229));
			fontPreviewPaneGraphics.drawRect(0,0,179,29);
			
			fontPreviewPaneGraphics.setColor(Color.WHITE);
			fontPreviewPaneGraphics.fillRect(1,1,178,28);
			
			fontPreviewPaneGraphics.setColor(Color.BLACK);
			fontPreviewPaneGraphics.setClip(0,0,180,30);
			if (boldBox.isSelected()||italicBox.isSelected()) {
				if (boldBox.isSelected()) {
					style=Font.BOLD;
				}
				if (italicBox.isSelected()) {
					style |= Font.ITALIC;
				}
			}
			fontPreviewPaneGraphics.setFont(new Font(fontChoice.getSelectedItem(),style,20));
			fontPreviewPaneGraphics.drawString("aA bB cC dD 1234",0,25);
		}
	}	
	
	public void stateChanged(ChangeEvent e) {
		//Update the Spinner Model for recalculating the maximum Value
		if (((Integer)generateStartIndex.getValue()).intValue() + ((Integer)generateCount.getValue()).intValue() < 255) {
			generateCount.setModel(new SpinnerNumberModel(((Integer)generateCount.getValue()).intValue(),1,255-((Integer)generateStartIndex.getValue()).intValue(),1));
		}else{
			//generateCount.setValue(new Integer(((Integer)generateCount.getValue()).intValue()-1));
			generateCount.setValue((((Integer)generateCount.getValue()).intValue()-1));
		}
	}
	
	public int showNewFontDialog(){
		this.setVisible(true);
		
		return returnValue;
	}
	
	public LCDFont getLCDFont(){
		return font;
	}

	
}
