package util;

import java.awt.Dimension;
import java.awt.Font;

public class LCDFont {
	private String name;	//Name der Schriftart
	private Dimension fontMetrics;	//6x8 oder 8x8 Font
	private int bigFontX;		// BigFont gre in x Richtung
	private int bigFontY;		// BigFont gre in y Richtung
	private Font importedFont;	// Wenn ja steht sie hier drin, sonst null
	private int generateStartIndex;	// Start index der Zeichen generierung
	private int generateCount;	// Anzahl der zu generierenden Zeichen
	private FontChar[] fontChars;	// Die Zeichen die diese Font besitzt
	
	public LCDFont(){
		
	}
	public int getBigFontX() {
		return bigFontX;
	}
	public void setBigFontX(int bigFontX) {
		this.bigFontX = bigFontX;
	}
	public int getBigFontY() {
		return bigFontY;
	}
	public void setBigFontY(int bigFontY) {
		this.bigFontY = bigFontY;
	}
	public Dimension getFontMetrics() {
		return fontMetrics;
	}
	public void setFontMetrics(Dimension fontMetrics) {
		this.fontMetrics = fontMetrics;
	}	
	public int getGenerateCount() {
		return generateCount;
	}
	public void setGenerateCount(int generateCount) {
		this.generateCount = generateCount;
		fontChars = new FontChar[generateCount];
	}
	public int getGenerateStartIndex() {
		return generateStartIndex;
	}
	public void setGenerateStartIndex(int generateStartIndex) {
		this.generateStartIndex = generateStartIndex;
	}
	public Font getImportedFont() {
		return importedFont;
	}
	public void setImportedFont(Font importedFont) {
		this.importedFont = importedFont;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public void setFontChar(FontChar fontChar,int index){
		 fontChars[index] = fontChar;
	}
	public FontChar getFontChar(int index){
		return fontChars[index];
	}
}
