/*
 * Some standard UART-Functions
 */


#include <avr/io.h>
#include <avr/iom32.h>
#include "uart.h"


void uart_init(int baud)
{
    UCSRB = (1 << TXEN);
    UCSRC = (3 << UCSZ0);
#if  defined(__AVR_ATmega32__)
    UCSRC |= (1 << URSEL);
#endif
    UBRRH = (uint8_t) ((F_CPU / (baud * 16L) -1) >> 8);
    UBRRL = (uint8_t) (F_CPU / (baud * 16L) -1);
}


void uart_putc(uint8_t data)
{
    while ( !( UCSRA & (1<<UDRE)) );
    UDR = data;
}


void uart_puts(const char *s)
{
    while (*s ){
      uart_putc(*s++);
    }
}
