/**
  ******************************************************************************
  * @file    test_program.c 
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    20-September-2013
  * @brief   Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2013 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software 
  * distributed under the License is distributed on an "AS IS" BASIS, 
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "test_program.h"
#include "image.h"
	#include "stdio.h"
	#include "stdlib.h"
#include   "string.h"




/** @addtogroup STM32F429I-Discovery_Demo
* @{
*/

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
#define ABS(x)         (x < 0) ? (-x) : x
#define L3G_Sensitivity_250dps     (float)   114.285f         /*!< gyroscope sensitivity with 250 dps full scale [LSB/dps]  */
#define L3G_Sensitivity_500dps     (float)    57.1429f        /*!< gyroscope sensitivity with 500 dps full scale [LSB/dps]  */
#define L3G_Sensitivity_2000dps    (float)    14.285f             /*!< gyroscope sensitivity with 2000 dps full scale [LSB/dps] */

/* Private variables ---------------------------------------------------------*/
#define IS42S16400J_SIZE_16             0x400000

static __IO uint32_t TimingDelay;
extern __IO uint32_t ButtonPressed;


float Buffer[6];
uint8_t Xval, Yval = 0x00;
L3GD20_InitTypeDef L3GD20_InitStructure;
L3GD20_FilterConfigTypeDef L3GD20_FilterStructure;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
* @brief  Main program.
* @param  None
* @retval None
*/


int main(void)
{
  
	  char str[] = "Test";
	 ;


  /*!< At this stage the microcontroller clock setting is already configured, 
  this is done through SystemInit() function which is called from startup
  file (startup_stm32f429_439xx.s) before to branch to application main.
  To reconfigure the default setting of SystemInit() function, refer to
  system_stm32f4xx.c file
  */     
  
  /* Setup SysTick Timer for 1 msec interrupts.*/
  if (SysTick_Config(SystemCoreClock / 1000))
  { 
    /* Capture error */ 
    while (1);
  }
  
  /* Initialize LEDs, User Button and LCD on STM32F429I-Disco ---------------------*/
  STM_EVAL_LEDInit(LED3);
  STM_EVAL_LEDInit(LED4);
  
  STM_EVAL_PBInit(BUTTON_USER, BUTTON_MODE_EXTI); 
  
  /* Display message on LCD ***************************************************/ 

  LCD_Init();
  LCD_LayerInit();
  
  /* LTDC reload configuration */  
  LTDC_ReloadConfig(LTDC_IMReload);
  
  /* Enable the LTDC */
  LTDC_Cmd(ENABLE);
  
  /* Set LCD foreground layer */
  LCD_SetLayer(LCD_FOREGROUND_LAYER);
  
  LCD_SetTransparency(0);

  /* Set LCD foreground layer */
  LCD_SetLayer(LCD_BACKGROUND_LAYER);


  
  /* TS Test */
  TP_Test();
  
  /* LCD display message */
  LCD_Clear(LCD_COLOR_BLUE);
  LCD_SetTextColor(LCD_COLOR_BLACK); 
  LCD_DisplayStringLine(LCD_LINE_1, (uint8_t*)"   MEMS TEST   ");
  LCD_DisplayStringLine(LCD_LINE_3, (uint8_t*)"      PUSH     ");
  LCD_DisplayStringLine(LCD_LINE_5, (uint8_t*)"  BUTTON USER  ");
  LCD_DisplayStringLine(LCD_LINE_7, (uint8_t*)"    TO START   ");
  LCD_DisplayStringLine(LCD_LINE_9, (uint8_t*)"  THIS IS THE  ");
  LCD_DisplayStringLine(LCD_LINE_11,(uint8_t*)"   LAST TEST   ");

  /* Wait for User button to be pressed */
  while (STM_EVAL_PBGetState(BUTTON_USER) != Bit_SET)
  {
  }
  /* Wait for User button is released */
  while (STM_EVAL_PBGetState(BUTTON_USER) != Bit_RESET)
  { }
  
  while (1)
  { 
  
   int fff ;
   fff=fff+1;// endlosschleife

  
  }
  
}




/**
* @brief  Touch Pannel Test.
* @param  
* @retval None
*/
void TP_Test(void)
{
  static TP_STATE* TP_State; 
  
  /* Clear the LCD */ 
  LCD_Clear(LCD_COLOR_BLUE2);
  





  /* Configure the IO Expander */
  if (IOE_Config() == IOE_OK)
  {
    /* Update the structure with the current position */
    TP_State = IOE_TP_GetState();
       char buffer_LC[20]=" 300000";


    unsigned long  Frequenz_LC  =0;

     ;
       long LC_entprellung =0;
       long LC_entprellung_Time =10;
  //  while (!(TP_State->TouchDetected) )
       while (1)
    {
      LCD_SetTextColor(LCD_COLOR_BLACK);


      LCD_DisplayStringLine(LCD_LINE_2,(uint8_t*)buffer_LC);

      int pos_x  =80;
              int pos_x1= 80;
    	      int pos_x2= 120;
    	      int pos_x3= 160;
    	      int pos_x4= 200;

     // int pos_y = 40;
             int pos_y1= 40;
             int pos_y2= 80;
             int pos_y3= 120;
             int posdd=30;

             pos_x=pos_x1;
      LCD_DisplayChar(pos_x,pos_y1,'7');
      LCD_DisplayChar(pos_x,pos_y2,'8');
      LCD_DisplayChar(pos_x,pos_y3,'9');
      LCD_SetTextColor(LCD_COLOR_RED);
      LCD_DrawRect(pos_y1, pos_x, posdd, posdd);
      LCD_DrawRect(pos_y2, pos_x, posdd, posdd);
      LCD_DrawRect(pos_y3, pos_x, posdd, posdd);
      pos_x=pos_x2;
LCD_DisplayChar(pos_x,pos_y1,'4');
LCD_DisplayChar(pos_x,pos_y2,'5');
LCD_DisplayChar(pos_x,pos_y3,'6');
LCD_SetTextColor(LCD_COLOR_RED);
LCD_DrawRect(pos_y1, pos_x, posdd, posdd);
LCD_DrawRect(pos_y2, pos_x, posdd, posdd);
LCD_DrawRect(pos_y3, pos_x, posdd, posdd);
pos_x=pos_x3;
LCD_DisplayChar(pos_x,pos_y1,'1');
LCD_DisplayChar(pos_x,pos_y2,'2');
LCD_DisplayChar(pos_x,pos_y3,'3');
LCD_SetTextColor(LCD_COLOR_RED);
LCD_DrawRect(pos_y1, pos_x, posdd, posdd);
LCD_DrawRect(pos_y2, pos_x, posdd, posdd);
LCD_DrawRect(pos_y3, pos_x, posdd, posdd);
pos_x=pos_x4;
LCD_DisplayChar(pos_x,pos_y1,'0');
LCD_DisplayChar(pos_x,pos_y2,'D');
LCD_DisplayChar(pos_x,pos_y3,'E');
LCD_SetTextColor(LCD_COLOR_RED);
LCD_DrawRect(pos_y1, pos_x, posdd, posdd);
LCD_DrawRect(pos_y2, pos_x, posdd, posdd);
LCD_DrawRect(pos_y3, pos_x, posdd, posdd);



      LCD_DisplayStringLine(LCD_LINE_1,(uint8_t*)"Bitte Fequenz");


  	 sprintf(buffer_LC, "%8.0ld" , Frequenz_LC);
      TP_State = IOE_TP_GetState(); 
      
      TP_State->X = TP_State->X;
      TP_State->Y = TP_State->Y;
      LC_entprellung=LC_entprellung-1;
      if (LC_entprellung< (-10000+2))
    	  LC_entprellung=-7;// berlauf verhindern

      if (LC_entprellung<0)
      {
  //  fr 7 8 9
      pos_x=pos_x1;
      //7
      if ((TP_State->TouchDetected) && (TP_State->Y < pos_x1+posdd) && (TP_State->Y > pos_x1) && (TP_State->X > pos_y1) && (TP_State->X < pos_y1+posdd))
      {
    	  ;
      Frequenz_LC= Frequenz_LC*10+7;
      LC_entprellung = LC_entprellung_Time;

      }
      //8
      else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x1+posdd) && (TP_State->Y > pos_x1) && (TP_State->X > pos_y2) && (TP_State->X < pos_y2+posdd))
      {
    	  	  ;
		Frequenz_LC=Frequenz_LC*10+8;
		 LC_entprellung = LC_entprellung_Time;
      }
      // 9
      else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x1+posdd) && (TP_State->Y > pos_x1) && (TP_State->X > pos_y3) && (TP_State->X < pos_y3+posdd))

      {
    	  ;
            Frequenz_LC=Frequenz_LC*10+9;
            LC_entprellung = LC_entprellung_Time;

      }
      //  fr 4 5 6

          //4
          else if ((TP_State->TouchDetected) && (TP_State->Y < pos_x2+posdd) && (TP_State->Y > pos_x2) && (TP_State->X > pos_y1) && (TP_State->X < pos_y1+posdd))
          {    Frequenz_LC=Frequenz_LC*10+4;
          LC_entprellung = LC_entprellung_Time;
          }
          //5
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x2+posdd) && (TP_State->Y > pos_x2) && (TP_State->X > pos_y2) && (TP_State->X < pos_y2+posdd))
          {    Frequenz_LC=Frequenz_LC*10+5;
          LC_entprellung = LC_entprellung_Time;
          }
          // 6
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x2+posdd) && (TP_State->Y > pos_x2) && (TP_State->X > pos_y3) && (TP_State->X < pos_y3+posdd))
          {    Frequenz_LC=Frequenz_LC*10+6;
          LC_entprellung = LC_entprellung_Time;
          }
      //  fr 1 2 3

          //1
          else if ((TP_State->TouchDetected) && (TP_State->Y < pos_x3+posdd) && (TP_State->Y > pos_x3) && (TP_State->X > pos_y1) && (TP_State->X < pos_y1+posdd))
          {    Frequenz_LC=Frequenz_LC*10+1;
          LC_entprellung = LC_entprellung_Time;
          }
          //2
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x3+posdd) && (TP_State->Y > pos_x3) && (TP_State->X > pos_y2) && (TP_State->X < pos_y2+posdd))
          {    Frequenz_LC=Frequenz_LC*10+2;
          LC_entprellung = LC_entprellung_Time;
          }
          // 3
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x3+posdd) && (TP_State->Y > pos_x3) && (TP_State->X > pos_y3) && (TP_State->X < pos_y3+posdd))
          {    Frequenz_LC=Frequenz_LC*10+3;
          LC_entprellung = LC_entprellung_Time;
          }
      //  fr 0 D E

          //0
          else if ((TP_State->TouchDetected) && (TP_State->Y < pos_x4+posdd) && (TP_State->Y > pos_x4) && (TP_State->X > pos_y1) && (TP_State->X < pos_y1+posdd))
          {    Frequenz_LC=Frequenz_LC*10+0;
          LC_entprellung = LC_entprellung_Time;
          }
          //D
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x4+posdd) && (TP_State->Y > pos_x4) && (TP_State->X > pos_y2) && (TP_State->X < pos_y2+posdd))
          {    Frequenz_LC=Frequenz_LC/10;
          LC_entprellung = LC_entprellung_Time;
          }
          // E
          else  if ((TP_State->TouchDetected) && (TP_State->Y < pos_x4+posdd) && (TP_State->Y > pos_x4) && (TP_State->X > pos_y3) && (TP_State->X < pos_y3+posdd))
          {    Frequenz_LC=000;
          LC_entprellung = LC_entprellung_Time;
          }

      else
      {
        TP_State->TouchDetected = 0;
      }
    }
    }
    
  }  
  else
  {
    LCD_Clear(LCD_COLOR_RED);
    LCD_SetTextColor(LCD_COLOR_BLACK); 
    LCD_DisplayStringLine(LCD_LINE_1,(uint8_t*)"   TS TEST     ");
    LCD_DisplayStringLine(LCD_LINE_3,(uint8_t*)"    FAILED     ");
    
       /* Waiting User Button is pressed */
        while ((STM_EVAL_PBGetState(BUTTON_USER) != Bit_SET))
        {}      
        /* Wait for User button is released */
        while (STM_EVAL_PBGetState(BUTTON_USER) != Bit_RESET)
        { }

  }
}









/**
* @brief  Inserts a delay time.
* @param  nTime: specifies the delay time length, in 10 ms.
* @retval None
*/
void Delay(__IO uint32_t nTime)
{
  TimingDelay = nTime;
  
  while(TimingDelay != 0);
}

/**
* @brief  Decrements the TimingDelay variable.
* @param  None
* @retval None
*/
void TimingDelay_Decrement(void)
{
  if (TimingDelay != 0x00)
  { 
    TimingDelay--;
  }
}


#ifdef  USE_FULL_ASSERT

/**
* @brief  Reports the name of the source file and the source line number
*   where the assert_param error has occurred.
* @param  file: pointer to the source file name
* @param  line: assert_param error line source number
* @retval None
*/
void assert_failed(uint8_t* file, uint32_t line)
{ 
  /* User can add his own implementation to report the file name and line number,
  ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  
  /* Infinite loop */
  while (1)
  {
  }
}
#endif

/**
* @}
*/


/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
