
// set to 1 to have data sent in packets w/ handshake
#define VUC_PACKET		1

// set to 1 to also have a checksum for each packet
#define VUC_PKT_CHK		1

// set to 1 to also have a sequence no for each packet
#define VUC_PKT_SEQ		1


#define CONCAT__2(a, b)		a ## b
#define CONCAT(a, b)		CONCAT__2(a, b)

#define STRINGIFY__(s)	#s
#define STRINGIFY(s)	STRINGIFY__(s)

// at most 4 data-bytes in
#define VUC_IN_DATA_SIZE	4


#define LED0_PORT_ADR	CON_OUT(LED0_PORT_NAME)
#define LED0_DDR_ADR	CON_DDR(LED0_PORT_NAME)

#define PWM_PORT_ADR	CON_OUT(PWM_PORT_NAME)
#define PWM_DDR_ADR	CON_DDR(PWM_PORT_NAME)

#define SCOPE_PORT_ADR	CON_OUT(SCOPE_PORT_NAME)
#define SCOPE_DDR_ADR	CON_DDR(SCOPE_PORT_NAME)


#if (PWM_COMP_CH==A)
#  define PWM_TOP_CH	B
#else
#  define PWM_TOP_CH	A
#endif
#define PWM_OUTPUT	CONCAT(PWM_TIMER_NO, PWM_COMP_CH)
#define PWM_ICR		CONCAT(ICR, PWM_TIMER_NO)
#define PWM_OCR		CONCAT(OCR, PWM_OUTPUT)
#define PWM_TCNT	CONCAT(TCNT, PWM_TIMER_NO)
#define PWM_TCCR_A	CONCAT3(TCCR, PWM_TIMER_NO, A)
#define PWM_TCCR_B	CONCAT3(TCCR, PWM_TIMER_NO, B)
#define PWM_OSIG	CONCAT3(CONCAT(TIMER, PWM_TIMER_NO), CONCAT(_COMP, PWM_COMP_CH), _vect)
#define PWM_ICNC	CONCAT(ICNC, PWM_TIMER_NO)
#define PWM_CS_0	CONCAT3(CS, PWM_TIMER_NO, 0)
#define PWM_CS_1	CONCAT3(CS, PWM_TIMER_NO, 1)
#define PWM_CS_2	CONCAT3(CS, PWM_TIMER_NO, 2)
#define PWM_WGM_0	CONCAT3(WGM, PWM_TIMER_NO, 0)
#define PWM_WGM_1	CONCAT3(WGM, PWM_TIMER_NO, 1)
#define PWM_WGM_2	CONCAT3(WGM, PWM_TIMER_NO, 2)
#define PWM_WGM_3	CONCAT3(WGM, PWM_TIMER_NO, 3)
#define PWM_ICF		CONCAT(ICF, PWM_TIMER_NO)
#define PWM_OCF		CONCAT3(OCF, PWM_TIMER_NO, PWM_COMP_CH)
#define PWM_COM_0	CONCAT3(COM, PWM_OUTPUT, 0)
#define PWM_COM_1	CONCAT3(COM, PWM_OUTPUT, 1)
#define PWM_OCIE	CONCAT(OCIE, PWM_OUTPUT)


#define SCOPE_TCCR_A	CONCAT3(TCCR, SCOPE_TIMER_NO, A)
#define SCOPE_WGM_0	CONCAT3(WGM, SCOPE_TIMER_NO, 0)
#define SCOPE_WGM_1	CONCAT3(WGM, SCOPE_TIMER_NO, 1)
#define SCOPE_WGM_2	CONCAT3(WGM, SCOPE_TIMER_NO, 2)
#define SCOPE_WGM_3	CONCAT3(WGM, SCOPE_TIMER_NO, 3)
#define SCOPE_TCCR_B	CONCAT3(TCCR, SCOPE_TIMER_NO, B)
#define SCOPE_CS_0	CONCAT3(CS, SCOPE_TIMER_NO, 0)
#define SCOPE_CS_1	CONCAT3(CS, SCOPE_TIMER_NO, 1)
#define SCOPE_CS_2	CONCAT3(CS, SCOPE_TIMER_NO, 2)
#define SCOPE_ICR	CONCAT(ICR, SCOPE_TIMER_NO)
#define SCOPE_OCR	CONCAT3(OCR, SCOPE_TIMER_NO, SCOPE_COMP_CH)
#define SCOPE_TIMSK	CONCAT(TIMSK, SCOPE_TIMER_NO)
#define SCOPE_OCIE	CONCAT3(OCIE, SCOPE_TIMER_NO, SCOPE_COMP_CH)
#define SCOPE_TIFR	CONCAT(TIFR, SCOPE_TIMER_NO)
#define SCOPE_OCF	CONCAT3(OCF, SCOPE_TIMER_NO, SCOPE_COMP_CH)



#if ((F_CPU/SCOPE_PRESC_VAL/SCOPE_FREQ) > 0xff)
#  error Scope timer resolution too small - decrease CPU clock or increase prescaler
#endif


#ifdef COM_UART
#  define com_getc	uart_getc
#  define com_putc	uart_putc
#  ifdef COM_INET
#    undef COM_INET
#  endif
#  ifdef COM_USB
#    undef COM_USB
#  endif
#  ifdef COM_UNIX
#    undef COM_UNIX
#  endif
#endif

#ifdef COM_UNIX
#  define com_getc	unix_getc
#  define com_putc	unix_putc
#endif


/*****************************************************/

#if (VUC_PUT_ADR_MAX<=0xff && VUC_GET_ADR_MAX<=0xff)
typedef u8 vuc_adr_t;
#else
typedef u16 vuc_adr_t;
#endif

/*
typedef i8 (* vuc_put_f)(u8 * data);
typedef i8 (* vuc_get_f)(u8 * data);

typedef struct {
  u8 no_of_bytes;
  vuc_put_f func;
} vuc_put_meta_t;

typedef struct {
  vuc_get_f func;
} vuc_get_meta_t;
*/

// "put"-commands:
i8 gen_put_freq (u8 * data);
i8 gen_put_power (u8 * data);
i8 scope_put_tb (u8 * data);

// "get"-commands:
i8 scope_get (u8 * data);
