
#define i8 int8_t
#define u8 uint8_t
#define i16 int16_t
#define u16 uint16_t
#define i32 int32_t
#define u32 uint32_t

#define lo8(n) (n&0xff)
#define hi8(n) ((n>>8)&0xff)

#define CON_OUT(name)		CONCAT(PORT, name)
#define CON_IN(name)		CONCAT(PIN, name)
#define CON_DDR(name)		CONCAT(DDR, name)

#define usleep(us)		_delay_loop_2( (F_CPU/4) / (us*1000000UL) );	// 1 tick = F_CPU/4 = 250nS@16MHz

#define G_STRINGIFY_(x)		#x
#define G_STRINGIFY(x)		G_STRINGIFY_(x)

// AVR 8-bit is also little-endian - what a lucky coincidence ;)
#define GINT16_TO_LE(x)		(x)
#define GUINT16_TO_LE(x)	(x)
#define GINT32_TO_LE(x)		(x)
#define GUINT32_TO_LE(x)	(x)
#define GINT16_FROM_LE(x)	(x)
#define GUINT16_FROM_LE(x)	(x)
#define GINT32_FROM_LE(x)	(x)
#define GUINT32_FROM_LE(x)	(x)

#ifdef __cplusplus
#  define G_BEGIN_DECLS		extern "C" {
#  define G_END_DECLS		}
#else
#  define G_BEGIN_DECLS		
#  define G_END_DECLS		
#endif

#define VUC_CB_HAS_USER		0

typedef i8 (* vuc_put_f)(u8 * data);

typedef struct {
  u16 no_of_bytes;
  vuc_put_f func;
  void * user;
} vuc_put_data_t;


typedef i8 (* vuc_get_f)(u8 * data);

typedef struct {
  vuc_get_f func;
  void * user;
} vuc_get_data_t;

