
#if (GTK_MAJOR_VERSION>=3) || (GTK_MAJOR_VERSION==2 && GTK_MINOR_VERSION>=90)
#  define GTK_3		1
#else
#  define GTK_3		0
#endif

#if (GTK_MAJOR_VERSION>=2)
#  define GTK_2		1
#else
#  define GTK_2		0
#endif

#define AGTK_CC3(a, b, c)		G_CONCAT(G_CONCAT(a, b), c)


#if (GTK_3)
#  define gtk_signal_connect(...)	g_signal_connect(__VA_ARGS__)
#  define GTK_OBJECT(...)		G_OBJECT(__VA_ARGS__)
#  define GTK_SIGNAL_FUNC(...)		G_CALLBACK(__VA_ARGS__)
#  define AGTK_SIG_REDRAW		"draw"
#else /* GTK_3 */
#  define AGTK_SIG_REDRAW		"expose-event"
#endif /* GTK_3 */


#if (GTK_2)
#  define gtk_signal_emit_by_name(...)	g_signal_emit_by_name(__VA_ARGS__)
#  define gtk_object_ref(...)		g_object_ref(__VA_ARGS__)
#  define gtk_object_unref(...)		g_object_unref(__VA_ARGS__)
#  define agtk_object_new(...)		g_object_new(__VA_ARGS__)
#else /* GTK_2 */
#  define agtk_object_new(...)		(void *)gtk_object_new(__VA_ARGS__)
#endif /* GTK_2 */


#if (GTK_2)
#  define GtkObjectClass		GObjectClass
#  define agtk_set_prop_func		set_property
#  define agtk_get_prop_func		get_property
#  define agtk_add_prop_int( \
    object_class, class_name, \
    id, flags, \
    name, nick, blurb, \
    min, max, default) \
      g_object_class_install_property( \
        G_OBJECT_CLASS(object_class), id, \
        g_param_spec_int(\
          name, nick, blurb, \
          min, max, default, \
          flags \
        ) \
      )
#  define agtk_add_prop_string( \
    object_class, class_name, \
    id, flags, \
    name, nick, blurb, \
    default) \
      g_object_class_install_property( \
        G_OBJECT_CLASS(object_class), id, \
        g_param_spec_string(\
          name, nick, blurb, \
          default, \
          flags \
        ) \
      )
#else /* GTK_2 */
#  define agtk_set_prop_func		set_arg
#  define agtk_get_prop_func		get_arg
#  define GTK_PARAM_READWRITE		GTK_ARG_READWRITE
#  define GTK_PARAM_READABLE		GTK_ARG_READABLE
#  define GTK_PARAM_CONSTRUCT		GTK_ARG_CONSTRUCT
#  define GTK_PARAM_CONSTRUCT_ONLY	GTK_ARG_CONSTRUCT_ONLY
#  define agtk_add_prop_int( \
    object_class, class_name, \
    id, flags, \
    name, nick, blurb, \
    min, max, default) \
      gtk_object_add_arg_type( \
        AGTK_CC3(class_name, "::", name), GTK_TYPE_INT, flags, id \
      )
#  define agtk_add_prop_string( \
    object_class, class_name, \
    id, flags, \
    name, nick, blurb, \
    default) \
      gtk_object_add_arg_type( \
        AGTK_CC3(class_name, "::", name), GTK_TYPE_STRING, flags, id \
      )
#endif /* GTK_2 */


#if (!GTK_2)

void gtk_widget_popup (GtkWidget * widget, gint x, gint y)
{
  gtk_window_move(GTK_WINDOW(widget), x, y);
  gtk_widget_show(widget);
}

#endif


#if ((GTK_MAJOR_VERSION==2) && (GTK_MINOR_VERSION<14))

GdkWindow * gtk_widget_get_window (GtkWidget * widget)
{
  return widget->window;
}

#endif


#if ((GTK_MAJOR_VERSION==2) && (GTK_MINOR_VERSION<18))

void gtk_widget_get_allocation (GtkWidget * widget, GtkAllocation * allocation)
{
  *allocation= widget->allocation;
}

#endif
