/*
* eia-232
* by themroc 2013-11-13
* this version always returns -1 in case of error
* fork of rs232 by:
*
***************************************************************************
*
* Author: Teunis van Beelen
*
* Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013 Teunis van Beelen
*
* teuniz@gmail.com
*
* hacked by themroc 2013-10-28
*
***************************************************************************
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation version 2 of the License.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
***************************************************************************
*
* This version of GPL is at http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
*
***************************************************************************
*/

/* last revision: February 1, 2013 */

/* For more info and how to use this libray, visit: http://www.teuniz.net/RS-232/ */


#ifndef EIA232_INCLUDED
#define EIA232_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <string.h>

#ifdef __linux__

#include <termios.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>

#define EIA232_HANDLE int

#else

#include <windows.h>

#define EIA232_HANDLE HANDLE

#endif

int EIA232_open (char * com_name, int baudrate, EIA232_HANDLE * com_handle);
void EIA232_close (EIA232_HANDLE);

int EIA232_poll (EIA232_HANDLE, void *, int);

int EIA232_send_byte (EIA232_HANDLE, char);
int EIA232_send_buf (EIA232_HANDLE, void *, int);
void EIA232_send_string (EIA232_HANDLE, const char *);

int EIA232_get_CTS (EIA232_HANDLE com_handle);
int EIA232_get_DSR (EIA232_HANDLE com_handle);
void EIA232_set_DTR (EIA232_HANDLE com_handle, int on);
void EIA232_set_RTS (EIA232_HANDLE com_handle, int on);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
