
#include "vuc_host.h"
#include "vuc_proto.h"
#include "vuc_types.h"

#include "vuc_object.h"
#include "vuc_button.h"
#include "vuc_vfader.h"
#include "vuc_scope.h"


// set to 1 to have data sent in packets w/ handshake
#define VUC_PACKET		1

// set to 1 to also have a checksum for each packet
#define VUC_PKT_CHK		1

// set to 1 to also have a sequence no for each packet
#define VUC_PKT_SEQ		1


#define COM_SER			1		// Include support for RS232
#define COM_USB			1		// Include support for USB (not implemented yet)
#define COM_UDP			1		// Include support for inet
#ifdef HAVE_SYS_SOCKET_H
#  define COM_UNIX		1		// Include support for unix domain sockets
#else
#  define COM_UNIX		0
#endif


#ifndef HAVE_GETTEXT
#  define _(a)		a
#  define P_(a)		a
#endif


/* receiver callback */
//typedef void (* vuc_in_f)(u8 * data, void * user);


/* install receiver callback */
void vuc_in (gint addr, u16 size, vuc_put_f func, gpointer user);

/* Send some 8-bit-values to uC */
void vuc_put_8 (guint channel, guint count, ...);

/* Send some 16-bit-values to uC */
void vuc_put_16 (guint channel, guint count, ...);


GtkBuilder * vuc_init (
  gint default_rate,
  gsize xml_len, const gchar * xml_data,
  int argc, char * argv[]
);

gint vuc_go (void);

gint vuc_exit (void);
