
#define VUC_DBG_ON	1

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include <glib.h>

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gtk/gtktogglebutton.h>

#include "libvucgtk.h"


#if (VUC_DBG_ON)
// debugging generally on
#  define dbgf(...)	msgf(__VA_ARGS__)
#else
#  define dbgf(...)	
#endif

int msgf (const char * fmt, ...)
{
  va_list args;

  va_start(args, fmt);
  vprintf(fmt, args);
  printf("\n");
  va_end(args);
}

int errf (const char * fmt, ...)
{
  va_list args;

  printf("ERROR! ");

  va_start(args, fmt);
  vprintf(fmt, args);
  printf("\n");
  va_end(args);
}

void vuc_prop_hdl_int (gint dir, GValue * value, gint * var)
{
  if (dir)
    *var= g_value_get_int(value);
  else
    g_value_set_int(value, *var);
}

void vuc_prop_hdl_string (gint dir, GValue * value, gchar ** var)
{
  if (dir)
    *var= (void *)g_value_get_string(value);
  else
    g_value_set_string(value, *var);
}
