
#include <config.h>

#ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#  include <sys/ioctl.h>
#  include <netdb.h>
#  define SOCK_TYPE	int
#else
#  ifdef HAVE_WINSOCK_H
#    define _WIN32_WINNT 0x0501	// We need at least xp
#    include <winsock2.h>
#    include <ws2tcpip.h>
#    define SOCK_TYPE	SOCKET
#  endif
#endif

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include "udp.h"

SOCK_TYPE udp_sd= -1;

int udp_init (char * server, char * port)
{
  int rc;
  struct addrinfo addr_in;
  struct addrinfo * addr_out, * ap;

#ifdef HAVE_WINSOCK_H
  WSADATA wsaData;
  rc= WSAStartup(MAKEWORD(2, 2), &wsaData);
  if (rc) {
    fprintf(stderr, "WSAStartup: %d\n", rc);
    return -1;
  }
#endif

  memset(&addr_in, 0, sizeof(struct addrinfo));
  addr_in.ai_family= AF_UNSPEC;	/* Allow IPv4 or IPv6 */
  addr_in.ai_socktype= SOCK_DGRAM;
  addr_in.ai_flags= 0;
  addr_in.ai_protocol= 0;
  rc= getaddrinfo(server, port, &addr_in, &addr_out);
  if (rc) {
    fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(rc));
    return -1;
  }

  for (ap= addr_out; ap!=NULL; ap= ap->ai_next) {
    udp_sd= socket(ap->ai_family, ap->ai_socktype, ap->ai_protocol);
    if (udp_sd<0)
      continue;

    rc= connect(udp_sd, ap->ai_addr, ap->ai_addrlen);
    if (rc>=0)
      break;
  }

  freeaddrinfo(addr_out);
  if (!ap)
    goto close_sd;

#ifdef HAVE_SYS_SOCKET_H
  int on= 1;
  ioctl(udp_sd, FIONBIO, &on);
#else
#  ifdef HAVE_WINSOCK_H
  u_long iMode= 1;
  ioctlsocket(udp_sd, FIONBIO, &iMode);
#  endif
#endif

  printf("Connected to %s:%s\n", server, port);
  return 1;

close_sd:
  close(udp_sd);
  fprintf(stderr, "Could not connect to %s:%s\n", server, port);
  return -1;
}

int udp_exit ()
{
  if (udp_sd > -1)
    close(udp_sd);

  return 0;
}

unsigned int udp_getc (void)
{
  char buf;
  ssize_t got;

  got= recv(udp_sd, &buf, 1, 0);
  return got>=0 ? buf : UDP_NO_DATA;
}

int udp_gets (void * buffer, int buf_size)
{
  return recv(udp_sd, buffer, buf_size, 0);
}

void udp_putc (char c)
{
  int rc;

  rc= send(udp_sd, &c, 1, 0);
  if (rc < 0)
    perror("send() failed");
}

void udp_puts (char * s, int len)
{
  int rc;

  rc= send(udp_sd, s, len, 0);
  if (rc < 0)
    perror("send() failed");
}
