
#include "config.h"

#ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#  include <sys/ioctl.h>
#  include <netdb.h>
#  define SOCK_TYPE	int
#else
#  ifdef HAVE_WINSOCK_H
#    define _WIN32_WINNT 0x0501	// We need at least xp
#    include <winsock2.h>
#    include <ws2tcpip.h>
#    define SOCK_TYPE	SOCKET
#  endif
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#include <glib.h>

#include "udp.h"

#define COM_SER		1
#define BUF_SIZE	4096


#if (COM_SER)

#include "eia-232.h"

EIA232_HANDLE ser_handle;

gint if_ser_init (gchar * com_name, gint baudrate)
{
  if (EIA232_open(com_name, baudrate, &ser_handle)<0) {
    return 0;
  }
  return 1;
}

#endif /* COM_SER */


void dump (unsigned char * buf, int len)
{
  int x;

  for (x=0; x<len && x<16; x++)
    printf("%02x ", buf[x]);
  if (x<len)
    printf("... (%d total) ", len);
}

int main (int argc, char *argv[])
{
  char * port= G_STRINGIFY(UDP_DEFAULT_PORT);
  int verbose= 0;
  int udp_sd= -1;
  int warm= 0;
  int rc;
  int i= 0;
  struct addrinfo addr_in;
  struct addrinfo * addr_out, * ap;

  struct sockaddr_storage client;
  socklen_t adr_len;
  ssize_t buf_s;
  char buf[BUF_SIZE];

  gchar ** remain= NULL;
  GOptionEntry entries[] = {
    { "verbose", 'V', 0, G_OPTION_ARG_NONE, &verbose, "Verbose mode", NULL },
//    { "if-type", 't', 0, G_OPTION_ARG_STRING, &if_type, "Interface type: 'ser' for RS232 (default)" COM_USB_OPT_STR, "TYPE" },
    { "port", 'p', 0, G_OPTION_ARG_STRING, &port, "Port address (default=" G_STRINGIFY(UDP_DEFAULT_PORT) ")", "PORT" },
    { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_STRING_ARRAY, &remain, NULL, NULL },
    { NULL }
  };
  GError * error= NULL;
  GOptionContext * context;

  context= g_option_context_new("[--] interface name [parameters]");
  g_option_context_add_main_entries(context, entries, NULL);
  if (!g_option_context_parse(context, &argc, &argv, &error)) {
    printf("option parsing failed: %s\n", error->message);
    exit(1);
  }
  g_option_context_free(context);

//  if (!if_type || strcasecmp(if_type, "ser")==0) {
    gint bd= 0;
    if (!remain || !remain[0]) {
      printf("Need serial port name.\n");
      exit(1);
    }
    if (remain[1])
      bd= atoi(remain[1]);
    if (!bd)
      bd= BAUDRATE;
    if (verbose)
      printf("Opening serial port '%s' with %d baud.\n", remain[0], bd);
    if (!if_ser_init(remain[0], bd))
      exit(3);
//  }

#ifdef HAVE_WINSOCK_H
  WSADATA wsaData;
  rc= WSAStartup(MAKEWORD(2, 2), &wsaData);
  if (rc) {
    fprintf(stderr, "WSAStartup: %d\n", rc);
    return -1;
  }
#endif

  if (verbose)
    printf("Opening udp port '%s'.\n", port);

  memset(&addr_in, 0, sizeof(struct addrinfo));
  addr_in.ai_family= AF_UNSPEC;	/* Allow IPv4 or IPv6 */
  addr_in.ai_socktype= SOCK_DGRAM;
  addr_in.ai_flags= AI_PASSIVE;
  addr_in.ai_protocol= 0;
  addr_in.ai_canonname= NULL;
  addr_in.ai_addr= NULL;
  addr_in.ai_next= NULL;
  rc= getaddrinfo(NULL, port, &addr_in, &addr_out);
  if (rc) {
    printf("getaddrinfo: %s\n", gai_strerror(rc));
    goto close_local;
  }

  for (ap= addr_out; ap!=NULL; ap= ap->ai_next) {
    udp_sd= socket(ap->ai_family, ap->ai_socktype, ap->ai_protocol);
    if (udp_sd<0)
      continue;

    rc= bind(udp_sd, ap->ai_addr, ap->ai_addrlen);
    if (rc>=0)
      break;

    goto close_sd;
  }

  freeaddrinfo(addr_out);
  if (!ap) {
    printf("Could not bind port %s\n", port);
    goto close_local;
  }

#ifdef HAVE_SYS_SOCKET_H
  int on= 1;
  ioctl(udp_sd, FIONBIO, &on);
#else
#  ifdef HAVE_WINSOCK_H
  u_long iMode= 1;
  ioctlsocket(udp_sd, FIONBIO, &iMode);
#  endif
#endif

  printf("%s <-> %s/udp\n", remain[0], port);

  while (1) {
    char host[NI_MAXHOST], service[NI_MAXSERV];

    adr_len= sizeof(struct sockaddr_storage);
    buf_s= recvfrom(udp_sd, buf, BUF_SIZE, 0, (struct sockaddr *)&client, &adr_len);
    if (buf_s>-1) {
      if (verbose || !warm) {
        rc= getnameinfo((struct sockaddr *)&client, adr_len, host, NI_MAXHOST, service, NI_MAXSERV, NI_NUMERICSERV);
        if (rc)
          printf("getnameinfo: %s\n", gai_strerror(rc));
        else
        if (!warm)
          printf("Connect from %s:%s\n", host, service);
      }
      warm= 1;
      EIA232_send_buf(ser_handle, buf, buf_s);
      if (verbose)
        { printf("%s <- ", remain[0]); dump(buf, buf_s); printf("\n"); }
      else
        { printf("<"); fflush(stdout); }
    }

    buf_s= EIA232_poll(ser_handle, buf, BUF_SIZE);
    if (buf_s>0 && warm) {
      rc= sendto(udp_sd, buf, buf_s, 0, (struct sockaddr *)&client, adr_len);
      if (rc<0)
        perror("Error sending response");
      else
      if (verbose)
        { dump(buf, rc /*buf_s*/); printf("-> %s:%s\n", host, service); }
      else
        { printf(">"); fflush(stdout); }
    }

    g_usleep(5*1000);
  }

close_sd:
  close(udp_sd);
close_local:
  EIA232_close(ser_handle);
  return 1;
}
