
#include <config.h>

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "unix.h"

int unix_sd= -1;

int unix_init (char * path)
{
  int    rc;
  struct sockaddr_un serveraddr;

  unix_sd= socket(AF_UNIX, SOCK_STREAM, 0);
  if (unix_sd < 0) {
    perror("socket() failed");
    return -1;
  }

  memset(&serveraddr, 0, sizeof(serveraddr));
  serveraddr.sun_family= AF_UNIX;
  strcpy(serveraddr.sun_path, path);

  rc= connect(unix_sd, (struct sockaddr *)&serveraddr, SUN_LEN(&serveraddr));
  if (rc < 0) {
    perror("connect() failed");
    goto close_sd;
  }

  printf("Connected to '%s'\n", path);
  return 1;

close_sd:
  close(unix_sd);
  return -1;
}

int unix_exit ()
{
  if (unix_sd != -1)
    close(unix_sd);

  return 0;
}

unsigned int unix_getc (void)
{
  int buf;
  ssize_t got;

  got= recv(unix_sd, &buf, 1, MSG_DONTWAIT);
  return got>=0 ? buf : UNIX_NO_DATA;
}

int unix_gets (void * buffer, int buf_size)
{
  return recv(unix_sd, buffer, buf_size, MSG_DONTWAIT);
}

void unix_putc (char c)
{
  int rc;

  rc= send(unix_sd, &c, 1, 0);
  if (rc < 0)
    perror("send() failed");
}

void unix_puts (char * s, int len)
{
  int rc;

  rc= send(unix_sd, s, len, 0);
  if (rc < 0)
    perror("send() failed");
}
