
#include <config.h>

#include <math.h>
#include <stdio.h>

#if (GTK_MAJOR_VERSION<2)
#  include <gdk/gdk.h>
#endif
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>
#include <gtk/gtkprivate.h>

#include "anygtk.h"
#include "vuc_host.h"
#include "vuc_proto.h"

#include "vuc_button.h"


enum {
  PROP_0,

  PROP_VUC_SIZE,
  PROP_VUC_ADDR,
  PROP_VUC_INIT,
  PROP_VUC_RUN,

  PROP_OFF_VAL,
  PROP_ON_VAL
};

static void set_property
  (GObject * obj, guint prop_id, const GValue * value, GParamSpec * pspec);
static void get_property
  (GObject * obj, guint prop_id, GValue * value, GParamSpec * pspec);


static void vuc_button_class_init (VucButtonClass * class)
{
  GtkObjectClass * object_class= (GtkObjectClass*)class;
  GtkWidgetClass * widget_class= (GtkWidgetClass*)class;

  object_class->agtk_set_prop_func= set_property;
  object_class->agtk_get_prop_func= get_property;
  agtk_add_prop_int(
    object_class, "VucButton", PROP_VUC_SIZE, GTK_PARAM_READWRITE,
    "vuc-size", NULL, NULL, 0, 0xffff, 0
  );
  agtk_add_prop_string(
    object_class, "VucButton", PROP_VUC_INIT, GTK_PARAM_WRITABLE,
    "vuc-init", NULL, NULL, ""
  );
  agtk_add_prop_string(
    object_class, "VucButton", PROP_VUC_RUN, GTK_PARAM_WRITABLE,
    "vuc-run", NULL, NULL, ""
  );
  agtk_add_prop_int(
    object_class, "VucButton", PROP_VUC_ADDR, GTK_PARAM_READWRITE,
    "vuc-addr", NULL, NULL, -1, VUC_ADDR_MAX, -1
  );
  agtk_add_prop_int(
    object_class, "VucButton", PROP_OFF_VAL, GTK_PARAM_READWRITE,
    "off-val", NULL, NULL, G_MININT, G_MAXINT, 0
  );
  agtk_add_prop_int(
    object_class, "VucButton", PROP_ON_VAL, GTK_PARAM_READWRITE,
    "on-val", NULL, NULL, G_MININT, G_MAXINT, 1
  );
}

static void vuc_button_init (VucButton * obj)
{
  obj->vuc_size= 0; obj->vuc_addr= -1;

  obj->off_val= 0; obj->on_val= 1;
}

G_DEFINE_TYPE(
  VucButton, vuc_button, GTK_TYPE_TOGGLE_BUTTON
)

static void property_handler
  (gint dir, GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  VucButton * obj= VUC_BUTTON(g_obj);

  switch (prop_id) {
    case PROP_VUC_SIZE: vuc_prop_hdl_int(dir, value, &obj->vuc_size); break;
    case PROP_VUC_ADDR: vuc_prop_hdl_int(dir, value, &obj->vuc_addr); break;
    case PROP_VUC_INIT: case PROP_VUC_RUN: break;

    case PROP_OFF_VAL: vuc_prop_hdl_int(dir, value, &obj->off_val); break;
    case PROP_ON_VAL: vuc_prop_hdl_int(dir, value, &obj->on_val); break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(g_obj, prop_id, pspec);
  }
}

static void set_property
  (GObject * g_obj, guint prop_id, const GValue * value, GParamSpec * pspec)
{
  property_handler(1, g_obj, prop_id, (void *)value, pspec);
}

static void get_property
  (GObject * g_obj, guint prop_id, GValue * value, GParamSpec * pspec)
{
  property_handler(0, g_obj, prop_id, value, pspec);
}

gboolean vuc_button_get_val (VucButton * obj)
{
  return gtk_toggle_button_get_active(&obj->p);
}
