
#ifndef __VUC_HOST_H__
#define __VUC_HOST_H__

#define i8 gint8
#define u8 guint8
#define i16 gint16
#define u16 guint16
#define i32 gint32
#define u32 guint32

#ifndef min
#  define min(a, b)		((a)<(b) ? (a) : (b))
#endif
#ifndef max
#  define max(a, b)		((a)>(b) ? (a) : (b))
#endif

#define float2i8(x)		((x)>=0 ? (i8)(min((x)+0.5, 127)) : (i8)(max((x)-0.5, -128)))
#define float2u8(x)		((x)>=0 ? (u8)(min((x)+0.5, 255)) : 0)

#define float2i16(x)		((x)>=0 ? (i16)(min((x)+0.5, 32767)) : (i16)(max((x)-0.5, -32768)))
#define float2u16(x)		((x)>=0 ? (u16)(min((x)+0.5, 65535)) : 0)

#define float2i32(x)		((x)>=0 ? (i32)(min((x)+0.5, 2147483647)) : (i32)(max((x)-0.5, -2147483648)))
#define float2u32(x)		((x)>=0 ? (u32)(min((x)+0.5, 4294967295)) : 0)

#define VUC_CB_HAS_USER		1

#endif /* __VUC_HOST_H__ */
